/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.table;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPCellEditor;
import org.eclipse.emf.ecp.edit.spi.swt.util.PreSetValidationStrategy;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public abstract class StringBasedCellEditor
extends TextCellEditor
implements ECPCellEditor {
    private String initialValue;

    public StringBasedCellEditor() {
    }

    public StringBasedCellEditor(Composite parent) {
        super(parent);
    }

    public StringBasedCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    public void activate(ColumnViewerEditorActivationEvent event) {
        this.initialValue = this.text.getText();
        if (event.eventType == 1 && this.isPrintable(event.character) && (this.getStyle() & 8) == 0) {
            this.doSetValue(String.valueOf(event.character));
        }
        super.activate(event);
    }

    protected void fireCancelEditor() {
        if (this.text != null && !this.text.isDisposed() && this.text.getText() != null && !this.text.getText().equals(this.initialValue)) {
            this.doSetValue(this.initialValue);
        }
        super.fireCancelEditor();
    }

    protected void doSetFocus() {
        super.doSetFocus();
        if (this.text.getText() != null) {
            this.text.setSelection(this.text.getText().length());
        }
    }

    protected UpdateValueStrategy withPreSetValidation(EStructuralFeature feature, UpdateValueStrategy delegate) {
        return new PreSetValidationStrategy(null, feature, delegate);
    }

    protected boolean isPrintable(char character) {
        return Character.isLetterOrDigit(character) || Character.valueOf(character).toString().matches("[\\.:,;\\-_#'+*~!?\u00a7$%&/()\\[\\]\\{\\}=\\\\\"]");
    }
}

