/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.service;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.util.ViewModelUtil;
import org.eclipse.emf.ecp.view.template.model.VTStyle;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.model.VTStyleSelector;
import org.eclipse.emf.ecp.view.template.model.VTTemplatePackage;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplate;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(name="viewTemplate", service={VTViewTemplateProvider.class})
public class ViewTemplateProviderImpl
implements VTViewTemplateProvider {
    private VTViewTemplate registeredTemplate;
    private ReportService reportService;

    @Reference(cardinality=ReferenceCardinality.MANDATORY, unbind="-")
    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Activate
    protected void startup(BundleContext bundleContext) {
        IConfigurationElement[] controls = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecp.view.template");
        if (controls.length == 0) {
            return;
        }
        if (controls.length > 1) {
            if (ViewModelUtil.isDebugMode()) {
                throw new IllegalArgumentException("Multiple template models found. Only one is supported.");
            }
            this.reportService.report(new AbstractReport("Multiple template models have been found. Only one of them will be used. Fix your project setup."));
        }
        IConfigurationElement e = controls[0];
        String xmiResource = e.getAttribute("xmi");
        Resource resource = ViewTemplateProviderImpl.loadResource(URI.createURI((String)("platform:/plugin/" + e.getContributor().getName() + "/" + xmiResource)));
        if (resource == null) {
            return;
        }
        if (resource.getContents().size() != 1) {
            return;
        }
        this.registeredTemplate = (VTViewTemplate)resource.getContents().get(0);
    }

    private static Resource loadResource(URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Map extensionToFactoryMap = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extensionToFactoryMap.put("*", new XMIResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://org/eclipse/emf/ecp/view/template/model", (Object)VTTemplatePackage.eINSTANCE);
        Resource resource = resourceSet.createResource(uri);
        try {
            resource.load(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int rsSize = resourceSet.getResources().size();
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        while (rsSize != resourceSet.getResources().size()) {
            EcoreUtil.resolveAll((ResourceSet)resourceSet);
            rsSize = resourceSet.getResources().size();
        }
        return resource;
    }

    public VTViewTemplate getViewTemplate() {
        if (this.registeredTemplate != null) {
            return (VTViewTemplate)EcoreUtil.copy((EObject)this.registeredTemplate);
        }
        return null;
    }

    public VTViewTemplate getMutableViewTemplate() {
        return this.registeredTemplate;
    }

    protected void setViewTemplate(VTViewTemplate viewTemplate) {
        this.registeredTemplate = viewTemplate;
    }

    public Set<VTStyleProperty> getStyleProperties(VElement vElement, ViewModelContext viewModelContext) {
        if (this.registeredTemplate == null) {
            return Collections.emptySet();
        }
        final LinkedHashMap<VTStyleProperty, Double> properties = new LinkedHashMap<VTStyleProperty, Double>();
        for (VTStyle style : this.registeredTemplate.getStyles()) {
            double specificity = style.getSelector().isApplicable(vElement, viewModelContext);
            if (VTStyleSelector.NOT_APPLICABLE == specificity) continue;
            for (VTStyleProperty styleProperty : style.getProperties()) {
                VTStyleProperty savedStyleProperty = this.getSavedStyleProperty(styleProperty, properties.keySet());
                if (savedStyleProperty == null) {
                    properties.put(styleProperty, specificity);
                    continue;
                }
                if ((Double)properties.get(savedStyleProperty) < specificity) {
                    properties.remove(savedStyleProperty);
                }
                properties.put(styleProperty, specificity);
            }
        }
        TreeSet<VTStyleProperty> treeSet = new TreeSet<VTStyleProperty>(new Comparator<VTStyleProperty>(){

            @Override
            public int compare(VTStyleProperty o1, VTStyleProperty o2) {
                Double specificity1 = (Double)properties.get(o1);
                Double specificity2 = (Double)properties.get(o2);
                int result = specificity2.compareTo(specificity1);
                if (result != 0) {
                    return result;
                }
                return o1.toString().compareTo(o2.toString());
            }
        });
        treeSet.addAll(properties.keySet());
        return treeSet;
    }

    private VTStyleProperty getSavedStyleProperty(VTStyleProperty style, Set<VTStyleProperty> properties) {
        if (style == null) {
            return null;
        }
        if (properties == null) {
            return null;
        }
        if (properties.isEmpty()) {
            return null;
        }
        for (VTStyleProperty styleProperty : properties) {
            if (!styleProperty.getClass().equals(style.getClass()) || !styleProperty.equalStyles(style)) continue;
            return styleProperty;
        }
        return null;
    }

    public boolean hasControlValidationTemplate() {
        return this.getMutableViewTemplate() != null && this.getMutableViewTemplate().getControlValidationConfiguration() != null;
    }
}

