/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core.properties;

import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.core.ECPRepository;
import org.eclipse.net4j.util.properties.DefaultPropertyTester;
import org.eclipse.net4j.util.properties.IProperties;
import org.eclipse.net4j.util.properties.Properties;
import org.eclipse.net4j.util.properties.Property;

public final class ECPRepositoryProperties
extends Properties<ECPRepository> {
    private static final IProperties<ECPRepository> INSTANCE = new ECPRepositoryProperties();

    private ECPRepositoryProperties() {
        super(ECPRepository.class);
        this.add((Property)new Property<ECPRepository>("name", "Name", "The name of this repository."){

            protected Object eval(ECPRepository repository) {
                return repository.getName();
            }
        });
        this.add((Property)new Property<ECPRepository>("repositoryLabel", "Repository", "The repository of this project."){

            protected Object eval(ECPRepository repository) {
                return repository.getLabel();
            }
        });
        this.add((Property)new Property<ECPRepository>("providerName"){

            protected Object eval(ECPRepository repository) {
                ECPProvider provider = repository.getProvider();
                if (provider != null) {
                    return provider.getName();
                }
                return "<unknown provider>";
            }
        });
    }

    public static final class Tester
    extends DefaultPropertyTester<ECPRepository> {
        private static final String NAMESPACE = "org.eclipse.emf.ecp.core.repository";

        public Tester() {
            super(NAMESPACE, INSTANCE);
        }
    }
}

