/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.categorization.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.edit.internal.swt.util.OverlayImageDescriptor;
import org.eclipse.emf.ecp.edit.spi.swt.util.SWTValidationHelper;
import org.eclipse.emf.ecp.view.spi.categorization.model.VAbstractCategorization;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategorizableElement;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategorizationElement;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategorizationPackage;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategory;
import org.eclipse.emf.ecp.view.spi.categorization.swt.ECPTreeViewAction;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.reporting.StatusReport;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.SWTDataElementIdHelper;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractJFaceTreeRenderer<VELEMENT extends VElement>
extends AbstractSWTRenderer<VELEMENT> {
    private final EMFFormsRendererFactory emfFormsRendererFactory;
    private SWTGridDescription gridDescription;
    private TreeSelectionChangedListener treeSelectionChangedListener;

    private EMFFormsRendererFactory getEMFFormsRendererFactory() {
        return this.emfFormsRendererFactory;
    }

    public AbstractJFaceTreeRenderer(VELEMENT vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsRendererFactory emfFormsRendererFactory) {
        super(vElement, viewContext, reportService);
        this.emfFormsRendererFactory = emfFormsRendererFactory;
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.gridDescription == null) {
            this.gridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.gridDescription;
    }

    protected void dispose() {
        this.gridDescription = null;
        this.getViewModelContext().unregisterViewChangeListener((ModelChangeListener)this.treeSelectionChangedListener);
        super.dispose();
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        EList<VAbstractCategorization> categorizations = this.getCategorizations();
        if (categorizations.size() == 1 && categorizations.get(0) instanceof VCategory) {
            AbstractSWTRenderer renderer;
            VElement child = (VElement)this.getCategorizations().get(0);
            try {
                renderer = this.getEMFFormsRendererFactory().getRendererInstance(child, this.getViewModelContext());
            }
            catch (EMFFormsNoRendererException ex) {
                this.getReportService().report((AbstractReport)new StatusReport(new Status(1, "org.eclipse.emf.ecp.view.categorization.swt", String.format("No Renderer for %s found.", new Object[]{child.eClass().getName(), ex}))));
                return null;
            }
            Control render = renderer.render(cell, parent);
            renderer.finalizeRendering(parent);
            SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)render, (VElement)this.getVElement(), (String)"vcategory", (ViewModelContext)this.getViewModelContext());
            return render;
        }
        Object detailPane = this.getViewModelContext().getContextValue("detailPane");
        if (detailPane != null && Composite.class.isInstance(detailPane)) {
            TreeViewer treeViewer = this.createTreeViewer(parent);
            ScrolledComposite editorComposite = this.createdEditorPane((Composite)Composite.class.cast(detailPane));
            this.setupTreeViewer(treeViewer, editorComposite);
            this.initTreeViewer(treeViewer);
            ((Composite)Composite.class.cast(detailPane)).layout();
            SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)treeViewer.getControl(), (VElement)this.getVElement(), (String)"tree", (ViewModelContext)this.getViewModelContext());
            return treeViewer.getControl();
        }
        SashForm sashForm = new SashForm(parent, 256);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)sashForm);
        TreeViewer treeViewer = this.createTreeViewer((Composite)sashForm);
        ScrolledComposite editorComposite = this.createdEditorPane((Composite)sashForm);
        this.setupTreeViewer(treeViewer, editorComposite);
        this.initTreeViewer(treeViewer);
        sashForm.setWeights(new int[]{1, 3});
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)treeViewer.getControl(), (VElement)this.getVElement(), (String)"tree", (ViewModelContext)this.getViewModelContext());
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)sashForm, (VElement)this.getVElement(), (String)"sash", (ViewModelContext)this.getViewModelContext());
        return sashForm;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        return new TreeViewer(parent, 4);
    }

    protected abstract EList<VAbstractCategorization> getCategorizations();

    protected abstract VCategorizationElement getCategorizationElement();

    protected ScrolledComposite createdEditorPane(Composite composite) {
        ScrolledComposite editorComposite = this.createScrolledComposite(composite);
        editorComposite.setExpandHorizontal(true);
        editorComposite.setExpandVertical(true);
        editorComposite.setShowFocusedControl(true);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)editorComposite);
        return editorComposite;
    }

    private ScrolledComposite createScrolledComposite(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 2816);
        scrolledComposite.setShowFocusedControl(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setBackground(parent.getBackground());
        return scrolledComposite;
    }

    protected void setupTreeViewer(final TreeViewer treeViewer, ScrolledComposite editorComposite) {
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return VCategorizableElement.class.isInstance(element) && ((VCategorizableElement)element).isVisible();
            }
        });
        GridDataFactory.fillDefaults().align(1, 4).grab(false, true).hint(400, -1).applyTo((Control)treeViewer.getTree());
        ArrayList<TreeEditor> editors = new ArrayList<TreeEditor>();
        final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        final AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory){

            public boolean hasChildren(Object object) {
                boolean hasChildren = super.hasChildren(object);
                if (hasChildren) {
                    Object[] objectArray = this.getChildren(object);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        ViewerFilter[] viewerFilterArray = treeViewer.getFilters();
                        int n3 = viewerFilterArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ViewerFilter viewerFilter = viewerFilterArray[n4];
                            if (viewerFilter.select((Viewer)treeViewer, object, o)) {
                                return true;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
                return false;
            }
        };
        final TreeTableLabelProvider treeTableLabelProvider = this.getTreeLabelProvider(treeViewer, (AdapterFactory)adapterFactory);
        treeViewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                contentProvider.dispose();
                treeTableLabelProvider.dispose();
                adapterFactory.dispose();
            }
        });
        treeViewer.setContentProvider((IContentProvider)contentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)treeTableLabelProvider);
        this.treeSelectionChangedListener = new TreeSelectionChangedListener(this.getViewModelContext(), editorComposite, this.getCategorizationElement(), treeViewer, editors);
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.treeSelectionChangedListener);
        this.getViewModelContext().registerViewChangeListener((ModelChangeListener)this.treeSelectionChangedListener);
        this.addTreeEditor(treeViewer, (EObject)this.getVElement(), editors);
    }

    protected TreeTableLabelProvider getTreeLabelProvider(TreeViewer treeViewer, AdapterFactory adapterFactory) {
        return new TreeTableLabelProvider(adapterFactory, treeViewer);
    }

    protected void initTreeViewer(TreeViewer treeViewer) {
        treeViewer.setInput((Object)this.getVElement());
        treeViewer.expandAll();
        if (this.getCategorizationElement().getCurrentSelection() != null) {
            treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.getCategorizationElement().getCurrentSelection()));
        } else if (this.getCategorizations().size() != 0) {
            treeViewer.setSelection((ISelection)new StructuredSelection(this.getCategorizations().get(0)));
        }
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(7, 7).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)composite);
        return composite;
    }

    protected void addTreeEditor(TreeViewer treeViewer, EObject view, final List<TreeEditor> editors) {
        Tree tree = treeViewer.getTree();
        int maxActions = 0;
        TreeIterator viewContents = view.eAllContents();
        while (viewContents.hasNext()) {
            VAbstractCategorization abstractCategorization;
            EObject object = (EObject)viewContents.next();
            if (!VAbstractCategorization.class.isInstance(object) || maxActions >= (abstractCategorization = (VAbstractCategorization)object).getActions().size()) continue;
            maxActions = abstractCategorization.getActions().size();
        }
        if (maxActions == 0) {
            return;
        }
        TreeColumn columnText = new TreeColumn(tree, 0);
        columnText.setWidth(300);
        columnText.setAlignment(4);
        int i = 0;
        while (i < maxActions) {
            TreeColumn column = new TreeColumn(tree, 0);
            column.setWidth(50);
            TreeEditor editor = new TreeEditor(tree);
            editor.horizontalAlignment = 0x1000000;
            editor.grabHorizontal = true;
            editor.minimumWidth = 50;
            editor.setColumn(i + 1);
            editors.add(editor);
            ++i;
        }
        tree.addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent e) {
            }

            public void treeCollapsed(TreeEvent e) {
                AbstractJFaceTreeRenderer.this.cleanUpTreeEditors(editors);
            }
        });
    }

    private void cleanUpTreeEditors(List<TreeEditor> editors) {
        for (TreeEditor editor : editors) {
            Control oldEditor = editor.getEditor();
            if (oldEditor == null) continue;
            oldEditor.dispose();
        }
    }

    protected void addButtons(TreeViewer treeViewer, TreeSelection treeSelection, List<TreeEditor> editors) {
        this.cleanUpTreeEditors(editors);
        if (treeSelection.getPaths().length == 0) {
            return;
        }
        TreeItem item = treeViewer.getTree().getSelection()[0];
        if (item == null) {
            return;
        }
        VCategorizableElement object = (VCategorizableElement)treeSelection.getFirstElement();
        if (object.getECPActions() == null) {
            return;
        }
        int i = 0;
        while (i < object.getECPActions().size()) {
            ECPTreeViewAction action = (ECPTreeViewAction)object.getECPActions().get(i);
            TreeEditor editor = editors.get(i);
            action.init(treeViewer, treeSelection, editor);
            action.execute();
            ++i;
        }
    }

    private final class TreeSelectionChangedListener
    implements ISelectionChangedListener,
    ModelChangeListener {
        private final ViewModelContext viewModelContext;
        private final ScrolledComposite editorComposite;
        private final VCategorizationElement vCategorizationElement;
        private final TreeViewer treeViewer;
        private final List<TreeEditor> editors;
        private Composite childComposite;
        private boolean busy;

        private TreeSelectionChangedListener(ViewModelContext viewModelContext, ScrolledComposite editorComposite, VCategorizationElement vCategorizationElement, TreeViewer treeViewer, List<TreeEditor> editors) {
            this.viewModelContext = viewModelContext;
            this.editorComposite = editorComposite;
            this.vCategorizationElement = vCategorizationElement;
            this.treeViewer = treeViewer;
            this.editors = editors;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TreeSelection treeSelection = (TreeSelection)event.getSelection();
            Object selection = treeSelection.getFirstElement();
            AbstractJFaceTreeRenderer.this.addButtons(this.treeViewer, treeSelection, this.editors);
            if (selection == null) {
                return;
            }
            this.onSelectionChanged((VElement)VElement.class.cast(selection));
        }

        public void onSelectionChanged(VElement child) {
            if (this.busy) {
                return;
            }
            this.busy = true;
            try {
                AbstractSWTRenderer renderer;
                if (this.childComposite != null) {
                    this.childComposite.dispose();
                    this.childComposite = null;
                }
                this.childComposite = AbstractJFaceTreeRenderer.this.createComposite((Composite)this.editorComposite);
                this.childComposite.setBackground(this.editorComposite.getBackground());
                this.editorComposite.setContent((Control)this.childComposite);
                try {
                    renderer = AbstractJFaceTreeRenderer.this.getEMFFormsRendererFactory().getRendererInstance(child, this.viewModelContext);
                }
                catch (EMFFormsNoRendererException ex) {
                    AbstractJFaceTreeRenderer.this.getReportService().report((AbstractReport)new StatusReport(new Status(1, "org.eclipse.emf.ecp.view.categorization.swt", String.format("No Renderer for %s found.", new Object[]{child.eClass().getName(), ex}))));
                    this.busy = false;
                    return;
                }
                try {
                    Control render = renderer.render((SWTGridCell)renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription()).getGrid().get(0), this.childComposite);
                    renderer.finalizeRendering(this.childComposite);
                    GridDataFactory.fillDefaults().align(4, 4).grab(true, true).minSize(-1, 200).applyTo(render);
                    this.vCategorizationElement.setCurrentSelection((VCategorizableElement)child);
                }
                catch (NoRendererFoundException e) {
                    AbstractJFaceTreeRenderer.this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
                }
                catch (NoPropertyDescriptorFoundExeption e) {
                    AbstractJFaceTreeRenderer.this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
                }
                this.childComposite.layout();
                Point point = this.childComposite.computeSize(-1, -1);
                this.editorComposite.setMinSize(point);
            }
            finally {
                this.busy = false;
            }
        }

        public void notifyChange(ModelChangeNotification notification) {
            if (notification.getNotifier() instanceof VCategorizationElement && notification.getStructuralFeature() == VCategorizationPackage.Literals.CATEGORIZATION_ELEMENT__CURRENT_SELECTION) {
                this.onSelectionChanged((VElement)notification.getNotifier());
            }
        }
    }

    protected class TreeTableLabelProvider
    extends AdapterFactoryLabelProvider
    implements ITableItemLabelProvider {
        private final TreeViewer treeViewer;

        public TreeTableLabelProvider(AdapterFactory adapterFactory, TreeViewer treeViewer) {
            super(adapterFactory);
            this.treeViewer = treeViewer;
        }

        public String getColumnText(Object object, int columnIndex) {
            this.adjustItemData(object);
            String text = super.getColumnText(object, columnIndex);
            if (columnIndex == 0 && VCategorizableElement.class.isInstance(object)) {
                text = super.getColumnText((Object)((VCategorizableElement)object).getLabelObject(), columnIndex);
            }
            return text;
        }

        private void adjustItemData(Object object) {
            if (!VElement.class.isInstance(object)) {
                return;
            }
            Widget widget = this.treeViewer.testFindItem(object);
            if (widget == null) {
                return;
            }
            if (widget.getData("org.eclipse.emfforms.elementId") != null) {
                return;
            }
            VElement element = (VElement)VElement.class.cast(object);
            SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)widget, (VElement)element, (String)"treeItem", (ViewModelContext)AbstractJFaceTreeRenderer.this.getViewModelContext());
        }

        public String getText(Object object) {
            this.adjustItemData(object);
            String text = VCategorizableElement.class.isInstance(object) ? super.getText((Object)((VCategorizableElement)object).getLabelObject()) : super.getText(object);
            return text;
        }

        public Image getColumnImage(Object object, int columnIndex) {
            if (columnIndex != 0) {
                return null;
            }
            Image image = super.getColumnImage(object, columnIndex);
            if (VCategorizableElement.class.isInstance(object)) {
                image = super.getColumnImage((Object)((VCategorizableElement)object).getLabelObject(), columnIndex);
            }
            return this.getValidationOverlay(image, (VElement)object);
        }

        public Image getImage(Object object) {
            Image image = VCategorizableElement.class.isInstance(object) ? super.getImage((Object)((VCategorizableElement)object).getLabelObject()) : super.getImage(object);
            return this.getValidationOverlay(image, (VElement)object);
        }

        protected Image getValidationOverlay(Image image, VElement categorization) {
            ImageDescriptor overlay = null;
            if (categorization.getDiagnostic() == null) {
                return image;
            }
            overlay = SWTValidationHelper.INSTANCE.getValidationOverlayDescriptor(categorization.getDiagnostic().getHighestSeverity(), AbstractJFaceTreeRenderer.this.getVElement(), AbstractJFaceTreeRenderer.this.getViewModelContext());
            if (overlay == null) {
                return image;
            }
            OverlayImageDescriptor imageDescriptor = new OverlayImageDescriptor(image, overlay, 2);
            Image resultImage = imageDescriptor.createImage();
            return resultImage;
        }
    }
}

