/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.editor.controls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jface.viewers.TreePath;

public final class Helper {
    private Helper() {
    }

    public static EClass getRootEClass(ECPProject project) {
        if (VView.class.isInstance(project.getContents().get(0))) {
            return ((VView)VView.class.cast(project.getContents().get(0))).getRootEClass();
        }
        return null;
    }

    public static EClass getRootEClass(EObject eObject) {
        EObject testObject = eObject;
        while (!VView.class.isInstance(testObject) && testObject != null) {
            testObject = testObject.eContainer();
        }
        if (VView.class.isInstance(testObject)) {
            return ((VView)testObject).getRootEClass();
        }
        return Helper.getRootEClass(ECPUtil.getECPProjectManager().getProject((Object)eObject));
    }

    public static void getReferenceMap(EClass parent, Map<EClass, EReference> childParentReferenceMap) {
        for (EReference eReference : parent.getEAllContainments()) {
            if (eReference.getEReferenceType().isSuperTypeOf(parent) || childParentReferenceMap.get(eReference.getEReferenceType()) != null) continue;
            childParentReferenceMap.put(eReference.getEReferenceType(), eReference);
            Helper.getReferenceMap(eReference.getEReferenceType(), childParentReferenceMap);
        }
    }

    public static List<EReference> getReferencePath(EClass rootEClass, EClass selectedClass, Map<EClass, EReference> childParentReferenceMap) {
        ArrayList<EReference> bottomUpPath = new ArrayList<EReference>();
        if (rootEClass == selectedClass) {
            return bottomUpPath;
        }
        EReference parentReference = childParentReferenceMap.get(selectedClass);
        while (parentReference != null && !bottomUpPath.contains(parentReference)) {
            bottomUpPath.add(parentReference);
            selectedClass = parentReference.getEContainingClass();
            if (selectedClass == rootEClass) break;
            parentReference = childParentReferenceMap.get(selectedClass);
        }
        Collections.reverse(bottomUpPath);
        return bottomUpPath;
    }

    public static Set<EClass> getDatasegmentSubclasses(EClass root) {
        LinkedHashSet<EClass> possibleSegments = new LinkedHashSet<EClass>();
        Helper.getDatasegmentSubclasses(root, possibleSegments);
        return possibleSegments;
    }

    private static void getDatasegmentSubclasses(EClass root, Set<EClass> possibleSegments) {
        if (possibleSegments.contains(root)) {
            return;
        }
        possibleSegments.add(root);
        for (EReference eReference : root.getEAllContainments()) {
            Helper.getDatasegmentSubclasses(eReference.getEReferenceType(), possibleSegments);
        }
    }

    public static boolean hasFeaturePropertyDescriptor(EStructuralFeature featureToCheck) {
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        AdapterFactoryItemDelegator adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
        IItemPropertyDescriptor propertyDescriptor = adapterFactoryItemDelegator.getPropertyDescriptor((Object)EcoreUtil.create((EClass)featureToCheck.getEContainingClass()), (Object)featureToCheck);
        composedAdapterFactory.dispose();
        return propertyDescriptor != null;
    }

    public static boolean hasFeaturePropertyDescriptor(EClass eClass, TreePath treePath) {
        EClass eClassToCheck = eClass;
        EStructuralFeature featureToCheck = (EStructuralFeature)treePath.getLastSegment();
        int segments = treePath.getSegmentCount();
        if (segments > 1 && EReference.class.isInstance(treePath.getSegment(segments - 1))) {
            eClassToCheck = ((EReference)EReference.class.cast(treePath.getSegment(segments - 1))).getEReferenceType();
        }
        if (eClassToCheck.isAbstract() || eClass.isInterface()) {
            return false;
        }
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        AdapterFactoryItemDelegator adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
        IItemPropertyDescriptor propertyDescriptor = adapterFactoryItemDelegator.getPropertyDescriptor((Object)EcoreUtil.create((EClass)eClassToCheck), (Object)featureToCheck);
        composedAdapterFactory.dispose();
        return propertyDescriptor != null;
    }
}

