/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.rule;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.internal.rule.ConditionServiceManager;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.rule.ConditionService;
import org.eclipse.emf.ecp.view.spi.rule.model.AndCondition;
import org.eclipse.emf.ecp.view.spi.rule.model.Condition;
import org.eclipse.emf.ecp.view.spi.rule.model.RulePackage;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component
public class AndConditionService
implements ConditionService<AndCondition> {
    private BundleContext bundleContext;
    private ServiceReference<ConditionServiceManager> conditionServiceManagerReference;
    private ConditionServiceManager conditionServiceManager;

    @Override
    public EClass getConditionType() {
        return RulePackage.eINSTANCE.getAndCondition();
    }

    @Override
    public Set<UniqueSetting> getConditionSettings(AndCondition condition, EObject domainModel) {
        LinkedHashSet<UniqueSetting> registeredSettings = new LinkedHashSet<UniqueSetting>();
        ConditionServiceManager conditionService = this.getConditionServiceManager();
        for (Condition cond : condition.getConditions()) {
            registeredSettings.addAll(conditionService.getConditionSettings(cond, domainModel));
        }
        return registeredSettings;
    }

    @Override
    public boolean evaluate(AndCondition condition, EObject domainModel) {
        if (condition == null) {
            return false;
        }
        return condition.evaluate(domainModel);
    }

    @Override
    public boolean evaluateChangedValues(AndCondition condition, EObject domainModel, Map<EStructuralFeature.Setting, Object> possibleNewValues) {
        if (condition == null) {
            return false;
        }
        return condition.evaluateChangedValues(domainModel, possibleNewValues);
    }

    @Override
    public Set<VDomainModelReference> getDomainModelReferences(AndCondition condition) {
        HashSet<VDomainModelReference> references = new HashSet<VDomainModelReference>();
        ConditionServiceManager conditionService = this.getConditionServiceManager();
        for (Condition cond : condition.getConditions()) {
            references.addAll(conditionService.getDomainModelReferences(cond));
        }
        return references;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        if (this.conditionServiceManagerReference != null) {
            bundleContext.ungetService(this.conditionServiceManagerReference);
            this.conditionServiceManager = null;
        }
    }

    private ConditionServiceManager getConditionServiceManager() {
        if (this.conditionServiceManager == null) {
            this.conditionServiceManagerReference = this.bundleContext.getServiceReference(ConditionServiceManager.class);
            if (this.conditionServiceManagerReference == null) {
                throw new IllegalStateException("No ConditionServiceManager available!");
            }
            this.conditionServiceManager = (ConditionServiceManager)this.bundleContext.getService(this.conditionServiceManagerReference);
        }
        return this.conditionServiceManager;
    }
}

