/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.stack.ui.swt;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.stack.model.VStackItem;
import org.eclipse.emf.ecp.view.spi.stack.model.VStackLayout;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.structuralchange.EMFFormsStructuralChangeTester;

public class StackItemViewService
implements ViewModelService {
    private ModelChangeListener domainListener;
    private ModelChangeListener stackItemsDomainListener;
    private ViewModelContext context;
    private VElement viewModel;
    private EObject domain;
    private Map<EObject, Map<EStructuralFeature, Set<VStackLayout>>> registry;

    public void instantiate(ViewModelContext context) {
        this.context = context;
        this.viewModel = context.getViewModel();
        this.domain = context.getDomainModel();
        this.registry = new LinkedHashMap<EObject, Map<EStructuralFeature, Set<VStackLayout>>>();
        this.initRegistry(this.viewModel);
        this.evaluateRegistry();
        this.domainListener = this.createDomainListener();
        context.registerDomainChangeListener(this.domainListener);
    }

    private void initRegistry(VElement viewModel) {
        LinkedHashSet<VStackLayout> stacks = new LinkedHashSet<VStackLayout>();
        TreeIterator iterator = viewModel.eAllContents();
        while (iterator.hasNext()) {
            EObject current = (EObject)iterator.next();
            if (!VStackLayout.class.isInstance(current)) continue;
            stacks.add((VStackLayout)VStackLayout.class.cast(current));
        }
        LinkedHashMap<VStackLayout, EStructuralFeature.Setting> stackToSetting = new LinkedHashMap<VStackLayout, EStructuralFeature.Setting>();
        for (VStackLayout stack : stacks) {
            VDomainModelReference dmr = stack.getDomainModelReference();
            if (dmr == null) continue;
            EStructuralFeature.Setting setting = this.addToRegistry(stack, dmr);
            if (setting == null) {
                return;
            }
            stackToSetting.put(stack, setting);
        }
        this.stackItemsDomainListener = new StackItemsModelChangeListener(stackToSetting);
        this.context.registerDomainChangeListener(this.stackItemsDomainListener);
    }

    private EStructuralFeature.Setting addToRegistry(VStackLayout stack, VDomainModelReference dmr) {
        IObservableValue observableValue;
        try {
            observableValue = ((EMFFormsDatabinding)this.context.getService(EMFFormsDatabinding.class)).getObservableValue(dmr, this.domain);
        }
        catch (DatabindingFailedException ex) {
            ((ReportService)this.context.getService(ReportService.class)).report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return null;
        }
        EObject eObject = (EObject)((IObserving)observableValue).getObserved();
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        observableValue.dispose();
        if (!eObject.eClass().getEAllStructuralFeatures().contains((Object)structuralFeature)) {
            return null;
        }
        this.addToRegistry(eObject, structuralFeature, stack);
        return ((InternalEObject)eObject).eSetting(structuralFeature);
    }

    private void addToRegistry(EObject object, EStructuralFeature domainModelEFeature, VStackLayout stack) {
        Map<EStructuralFeature, Set<VStackLayout>> featureToLayoutMap;
        if (!this.registry.containsKey(object)) {
            this.registry.put(object, new LinkedHashMap());
        }
        if (!(featureToLayoutMap = this.registry.get(object)).containsKey(domainModelEFeature)) {
            featureToLayoutMap.put(domainModelEFeature, new LinkedHashSet());
        }
        featureToLayoutMap.get(domainModelEFeature).add(stack);
    }

    private boolean doesRegistryContain(EObject object, EStructuralFeature domainModelEFeature) {
        if (!this.registry.containsKey(object)) {
            return false;
        }
        Map<EStructuralFeature, Set<VStackLayout>> featureToStackMap = this.registry.get(object);
        return featureToStackMap.containsKey(domainModelEFeature);
    }

    private void evaluateRegistry() {
        for (EObject object : this.registry.keySet()) {
            Map<EStructuralFeature, Set<VStackLayout>> featureToStacksMap = this.registry.get(object);
            for (EStructuralFeature feature : featureToStacksMap.keySet()) {
                this.evaluate(object, feature);
            }
        }
    }

    private void evaluate(EObject object, EStructuralFeature domainModelEFeature) {
        Object currentValue = object.eGet(domainModelEFeature);
        Set<VStackLayout> stacks = this.registry.get(object).get(domainModelEFeature);
        for (VStackLayout stack : stacks) {
            boolean topElementSet = false;
            for (VStackItem item : stack.getStackItems()) {
                if (currentValue == null) {
                    if (currentValue != item.getValue()) continue;
                    stack.setTopElement(item);
                    topElementSet = true;
                    break;
                }
                if (EcorePackage.eINSTANCE.getEEnum().isInstance((Object)domainModelEFeature.getEType()) && ((Enumerator)Enumerator.class.cast(currentValue)).getLiteral().equals(item.getValue())) {
                    stack.setTopElement(item);
                    topElementSet = true;
                    break;
                }
                if (!currentValue.equals(item.getValue())) continue;
                stack.setTopElement(item);
                topElementSet = true;
                break;
            }
            if (topElementSet) continue;
            stack.setTopElement(null);
        }
    }

    private ModelChangeListener createDomainListener() {
        return new StackDomainChangeListener();
    }

    public void dispose() {
        this.viewModel = null;
        this.domain = null;
        this.registry.clear();
        this.registry = null;
        this.context.unregisterDomainChangeListener(this.stackItemsDomainListener);
        this.stackItemsDomainListener = null;
        this.context.unregisterDomainChangeListener(this.domainListener);
        this.domainListener = null;
        this.context = null;
    }

    public int getPriority() {
        return 7;
    }

    private class StackDomainChangeListener
    implements ModelChangeListener {
        private StackDomainChangeListener() {
        }

        public void notifyChange(ModelChangeNotification notification) {
            EStructuralFeature feature;
            EObject notifier = notification.getNotifier();
            if (!StackItemViewService.this.doesRegistryContain(notifier, feature = notification.getStructuralFeature())) {
                return;
            }
            StackItemViewService.this.evaluate(notifier, feature);
        }
    }

    private class StackItemsModelChangeListener
    implements ModelChangeListener {
        private final Map<VStackLayout, EStructuralFeature.Setting> stackToSetting;

        StackItemsModelChangeListener(Map<VStackLayout, EStructuralFeature.Setting> stackToSetting) {
            this.stackToSetting = stackToSetting;
        }

        public void notifyChange(ModelChangeNotification notification) {
            EMFFormsStructuralChangeTester tester = (EMFFormsStructuralChangeTester)StackItemViewService.this.context.getService(EMFFormsStructuralChangeTester.class);
            for (VStackLayout stack : this.stackToSetting.keySet()) {
                if (!tester.isStructureChanged(stack.getDomainModelReference(), StackItemViewService.this.context.getDomainModel(), notification)) continue;
                this.removeOutdatedEntriesFromRegistry(stack);
                this.addCurrentEntriesToRegistry(stack);
                EStructuralFeature.Setting setting = this.stackToSetting.get(stack);
                StackItemViewService.this.evaluate(setting.getEObject(), setting.getEStructuralFeature());
            }
        }

        private void removeOutdatedEntriesFromRegistry(VStackLayout stack) {
            EStructuralFeature.Setting setting = this.stackToSetting.get(stack);
            Map featureToStackMap = (Map)StackItemViewService.this.registry.get(setting.getEObject());
            Set stacks = (Set)featureToStackMap.get(setting.getEStructuralFeature());
            stacks.remove(stack);
            if (!stacks.isEmpty()) {
                return;
            }
            featureToStackMap.remove(setting.getEStructuralFeature());
            if (!featureToStackMap.isEmpty()) {
                return;
            }
            StackItemViewService.this.registry.remove(setting.getEObject());
        }

        private void addCurrentEntriesToRegistry(VStackLayout stack) {
            EStructuralFeature.Setting setting = StackItemViewService.this.addToRegistry(stack, stack.getDomainModelReference());
            this.stackToSetting.put(stack, setting);
        }
    }
}

