/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.ecore.actions;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class CreateNewInstaceWizard
extends Wizard {
    public static final List<String> FILE_EXTENSIONS = Collections.singletonList("xmi");
    public static final String FORMATTED_FILE_EXTENSIONS = ".xmi";
    private CreateNewInstanceFileCreationPage newFileCreationPage;
    private final EClass eClass;

    public CreateNewInstaceWizard(EClass eClass) {
        this.eClass = eClass;
    }

    public boolean performFinish() {
        final IFile modelFile = this.getModelFile();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                Resource resource = resourceSet.createResource(fileURI);
                EObject instance = EcoreUtil.create((EClass)CreateNewInstaceWizard.this.eClass);
                resource.getContents().add((Object)instance);
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("ENCODING", "UTF-8");
                options.put("SCHEMA_LOCATION", Boolean.TRUE);
                options.put("LINE_WIDTH", 80);
                try {
                    try {
                        resource.save(options);
                    }
                    catch (IOException exception) {
                        CreateNewInstaceWizard.this.openErrorDialog(exception);
                        progressMonitor.done();
                        return;
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            return true;
        }
        catch (InvocationTargetException exception) {
            this.openErrorDialog(exception);
            return false;
        }
        catch (InterruptedException exception) {
            this.openErrorDialog(exception);
            return false;
        }
    }

    private void openErrorDialog(Exception exception) {
        Status status = new Status(4, "org.eclipse.emfforms.editor.ecore", "Could not create instance file.", (Throwable)exception);
        ErrorDialog.openError((Shell)this.getShell(), (String)"Error", null, (IStatus)status);
    }

    public void addPages() {
        this.newFileCreationPage = new CreateNewInstanceFileCreationPage("CreatePage", (IStructuredSelection)new StructuredSelection((Object)this.eClass));
        String className = this.eClass.getName();
        this.newFileCreationPage.setTitle("Create New Instance In File");
        this.newFileCreationPage.setDescription("Create a new file to save a new instance of EClass " + className + ".");
        this.newFileCreationPage.setFileName(String.valueOf(className) + "." + FILE_EXTENSIONS.get(0));
        this.addPage((IWizardPage)this.newFileCreationPage);
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    public class CreateNewInstanceFileCreationPage
    extends WizardNewFileCreationPage {
        public CreateNewInstanceFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String extension = new Path(this.getFileName()).getFileExtension();
                if (extension == null || !FILE_EXTENSIONS.contains(extension)) {
                    this.setErrorMessage("Wrong file extension: Use .xmi");
                    return false;
                }
                return true;
            }
            return false;
        }

        public IFile getModelFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }
    }
}

