/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.model.util;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecp.view.spi.model.DateTimeDisplayType;
import org.eclipse.emf.ecp.view.spi.model.DomainModelReferenceChangeListener;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VAttachment;
import org.eclipse.emf.ecp.view.spi.model.VContainedContainer;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VContainer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDateTimeDisplayAttachment;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VFeatureDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VHasTooltip;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewModelLoadingProperties;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;

public class ViewValidator
extends EObjectValidator {
    public static final String ECLASS_KEY = "dmr_resolvement_eclass";
    public static final ViewValidator INSTANCE = new ViewValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.ecp.view.spi.model";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return VViewPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateDiagnostic((VDiagnostic)value, diagnostics, context);
            }
            case 1: {
                return this.validateAttachment((VAttachment)value, diagnostics, context);
            }
            case 2: {
                return this.validateDomainModelReference((VDomainModelReference)value, diagnostics, context);
            }
            case 3: {
                return this.validateFeaturePathDomainModelReference((VFeaturePathDomainModelReference)value, diagnostics, context);
            }
            case 4: {
                return this.validateElement((VElement)value, diagnostics, context);
            }
            case 5: {
                return this.validateView((VView)value, diagnostics, context);
            }
            case 6: {
                return this.validateContainedElement((VContainedElement)value, diagnostics, context);
            }
            case 7: {
                return this.validateContainer((VContainer)value, diagnostics, context);
            }
            case 8: {
                return this.validateContainedContainer((VContainedContainer)value, diagnostics, context);
            }
            case 9: {
                return this.validateControl((VControl)value, diagnostics, context);
            }
            case 10: {
                return this.validateViewModelLoadingProperties((VViewModelLoadingProperties)value, diagnostics, context);
            }
            case 11: {
                return this.validateStringToObjectMapEntry((Map.Entry)value, diagnostics, context);
            }
            case 12: {
                return this.validateViewModelProperties((VViewModelProperties)value, diagnostics, context);
            }
            case 13: {
                return this.validateDateTimeDisplayAttachment((VDateTimeDisplayAttachment)value, diagnostics, context);
            }
            case 14: {
                return this.validateHasTooltip((VHasTooltip)value, diagnostics, context);
            }
            case 15: {
                return this.validateDomainModelReferenceSegment((VDomainModelReferenceSegment)value, diagnostics, context);
            }
            case 16: {
                return this.validateFeatureDomainModelReferenceSegment((VFeatureDomainModelReferenceSegment)value, diagnostics, context);
            }
            case 17: {
                return this.validateLabelAlignment((LabelAlignment)((Object)value), diagnostics, context);
            }
            case 18: {
                return this.validateDateTimeDisplayType((DateTimeDisplayType)((Object)value), diagnostics, context);
            }
            case 19: {
                return this.validateDomainModelReferenceChangeListener((DomainModelReferenceChangeListener)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateDiagnostic(VDiagnostic diagnostic, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(diagnostic, diagnostics, context);
    }

    public boolean validateAttachment(VAttachment attachment, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(attachment, diagnostics, context);
    }

    public boolean validateDomainModelReference(VDomainModelReference domainModelReference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(domainModelReference, diagnostics, context);
    }

    public boolean validateFeaturePathDomainModelReference(VFeaturePathDomainModelReference featurePathDomainModelReference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(featurePathDomainModelReference, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(featurePathDomainModelReference, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(featurePathDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(featurePathDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(featurePathDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(featurePathDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(featurePathDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(featurePathDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(featurePathDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFeaturePathDomainModelReference_resolveable(featurePathDomainModelReference, diagnostics, context);
        }
        return result;
    }

    public boolean validateFeaturePathDomainModelReference_resolveable(VFeaturePathDomainModelReference featurePathDomainModelReference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (featurePathDomainModelReference.getDomainModelEFeature() == null) {
            if (featurePathDomainModelReference.eContainer() != null) {
                diagnostics.add(this.createDiagnostic(4, 0, "No EFeature set.", featurePathDomainModelReference.eContainer(), featurePathDomainModelReference.eContainingFeature()));
            }
            return false;
        }
        if ((VDomainModelReference.class.isInstance(featurePathDomainModelReference.eContainer()) || VDomainModelReferenceSegment.class.isInstance(featurePathDomainModelReference.eContainer())) && !context.containsKey(ECLASS_KEY)) {
            return true;
        }
        VView parentView = this.getParentView(featurePathDomainModelReference);
        EClass rootEClass = null;
        if (context.containsKey(ECLASS_KEY)) {
            rootEClass = (EClass)context.get(ECLASS_KEY);
        }
        if (rootEClass == null && parentView != null && (rootEClass = parentView.getRootEClass()) == null && diagnostics != null) {
            diagnostics.add(this.createDiagnostic(2, 0, "Parent view has no root EClass set. The reference may be unresolveable.", featurePathDomainModelReference.eContainer(), featurePathDomainModelReference.eContainingFeature()));
        }
        if (rootEClass == null) {
            if (this.isProxy(featurePathDomainModelReference)) {
                return false;
            }
            rootEClass = featurePathDomainModelReference.getDomainModelEReferencePath().isEmpty() ? (EClass)featurePathDomainModelReference.getDomainModelEFeature().eContainer() : (EClass)((EReference)featurePathDomainModelReference.getDomainModelEReferencePath().get(0)).eContainer();
        }
        EClass current = rootEClass;
        for (EReference reference : featurePathDomainModelReference.getDomainModelEReferencePath()) {
            if (!current.getEAllReferences().contains((Object)reference)) {
                if (diagnostics != null) {
                    String message = "Domain model reference is unresolveable. Failed on reference: " + reference.getName();
                    if (featurePathDomainModelReference.eContainer() != null) {
                        diagnostics.add(this.createDiagnostic(4, 0, message, featurePathDomainModelReference.eContainer(), featurePathDomainModelReference.eContainingFeature()));
                    }
                    diagnostics.add(this.createDiagnostic(4, 0, message, featurePathDomainModelReference, (EStructuralFeature)VViewPackage.eINSTANCE.getFeaturePathDomainModelReference_DomainModelEReferencePath()));
                }
                return false;
            }
            current = reference.getEReferenceType();
            if (current != null) continue;
            String message = MessageFormat.format("Domain model reference is unresolveable. EReference {0} has no type. Please check the ecore", reference.getName());
            if (featurePathDomainModelReference.eContainer() != null) {
                diagnostics.add(this.createDiagnostic(4, 0, message, featurePathDomainModelReference.eContainer(), featurePathDomainModelReference.eContainingFeature()));
            }
            diagnostics.add(this.createDiagnostic(4, 0, message, featurePathDomainModelReference, (EStructuralFeature)VViewPackage.eINSTANCE.getFeaturePathDomainModelReference_DomainModelEReferencePath()));
            return false;
        }
        if (!current.getEAllStructuralFeatures().contains((Object)featurePathDomainModelReference.getDomainModelEFeature())) {
            if (diagnostics != null) {
                String message = "Domain model reference is unresolveable. Failed on domain model feature: " + featurePathDomainModelReference.getDomainModelEFeature().getName();
                if (featurePathDomainModelReference.eContainer() != null) {
                    diagnostics.add(this.createDiagnostic(4, 0, message, featurePathDomainModelReference.eContainer(), featurePathDomainModelReference.eContainingFeature()));
                }
                diagnostics.add(this.createDiagnostic(4, 0, message, featurePathDomainModelReference, (EStructuralFeature)VViewPackage.eINSTANCE.getFeaturePathDomainModelReference_DomainModelEFeature()));
            }
            return false;
        }
        return true;
    }

    private boolean isProxy(VFeaturePathDomainModelReference featurePathDomainModelReference) {
        if (featurePathDomainModelReference.getDomainModelEFeature().eIsProxy()) {
            return true;
        }
        for (EReference eReference : featurePathDomainModelReference.getDomainModelEReferencePath()) {
            if (!eReference.eIsProxy()) continue;
            return true;
        }
        return false;
    }

    private Diagnostic createDiagnostic(int severity, int code, String message, EObject object, EStructuralFeature feature) {
        return new BasicDiagnostic(severity, DIAGNOSTIC_SOURCE, code, message, new Object[]{object, feature});
    }

    private VView getParentView(VDomainModelReference reference) {
        EObject parent = reference.eContainer();
        while (parent != null && !VView.class.isInstance(parent)) {
            parent = parent.eContainer();
        }
        return (VView)VView.class.cast(parent);
    }

    public boolean validateElement(VElement element, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(element, diagnostics, context);
    }

    public boolean validateView(VView view, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(view, diagnostics, context);
    }

    public boolean validateContainedElement(VContainedElement containedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(containedElement, diagnostics, context);
    }

    public boolean validateContainer(VContainer container, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(container, diagnostics, context);
    }

    public boolean validateContainedContainer(VContainedContainer containedContainer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(containedContainer, diagnostics, context);
    }

    public boolean validateControl(VControl control, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(control, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(control, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(control, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(control, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(control, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(control, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(control, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(control, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(control, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateControl_resolveable(control, diagnostics, context);
        }
        return result;
    }

    public boolean validateControl_resolveable(VControl control, DiagnosticChain diagnostics, Map<Object, Object> context) {
        VDomainModelReference domainModelReference = control.getDomainModelReference();
        if (domainModelReference == null) {
            diagnostics.add(this.createDiagnostic(4, 0, "No Domain Model Reference set.", control, (EStructuralFeature)VViewPackage.eINSTANCE.getControl_DomainModelReference()));
            return false;
        }
        if (domainModelReference instanceof VFeaturePathDomainModelReference) {
            return this.validateFeaturePathDomainModelReference_resolveable((VFeaturePathDomainModelReference)domainModelReference, diagnostics, context);
        }
        return this.validateDomainModelReference(domainModelReference, diagnostics, context);
    }

    public boolean validateViewModelLoadingProperties(VViewModelLoadingProperties viewModelLoadingProperties, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(viewModelLoadingProperties, diagnostics, context);
    }

    public boolean validateStringToObjectMapEntry(Map.Entry<?, ?> stringToObjectMapEntry, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)stringToObjectMapEntry, diagnostics, context);
    }

    public boolean validateViewModelProperties(VViewModelProperties viewModelProperties, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(viewModelProperties, diagnostics, context);
    }

    public boolean validateDateTimeDisplayAttachment(VDateTimeDisplayAttachment dateTimeDisplayAttachment, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(dateTimeDisplayAttachment, diagnostics, context);
    }

    public boolean validateHasTooltip(VHasTooltip hasTooltip, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(hasTooltip, diagnostics, context);
    }

    public boolean validateDomainModelReferenceSegment(VDomainModelReferenceSegment domainModelReferenceSegment, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(domainModelReferenceSegment, diagnostics, context);
    }

    public boolean validateFeatureDomainModelReferenceSegment(VFeatureDomainModelReferenceSegment featureDomainModelReferenceSegment, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(featureDomainModelReferenceSegment, diagnostics, context);
    }

    public boolean validateLabelAlignment(LabelAlignment labelAlignment, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateDateTimeDisplayType(DateTimeDisplayType dateTimeDisplayType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateDomainModelReferenceChangeListener(DomainModelReferenceChangeListener domainModelReferenceChangeListener, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

