/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.ide.internal.builder;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emfforms.bazaar.Bazaar;
import org.eclipse.emfforms.bazaar.BazaarContext;
import org.eclipse.emfforms.bazaar.Vendor;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.ide.builder.MarkerHelperProvider;
import org.eclipse.emfforms.ide.builder.ValidationDelegate;
import org.eclipse.emfforms.ide.builder.ValidationDelegateProvider;
import org.eclipse.emfforms.ide.internal.builder.Activator;

public class ValidationBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.emfforms.ide.builder.validationBuilder";
    public static final String MARKER_ID = "org.eclipse.emfforms.ide.builder.ValidationProblem";
    private final EditUIMarkerHelper projectMarkerHelper = new EditUIMarkerHelper(){

        protected String getMarkerID() {
            return ValidationBuilder.MARKER_ID;
        }
    };

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected <T> Bazaar.Builder<T> createBazaarBuilder(Vendor<? extends T> defaultVendor) {
        return Bazaar.Builder.empty().add(defaultVendor);
    }

    protected Bazaar.Builder<ValidationDelegate> configureValidation(Bazaar.Builder<ValidationDelegate> bazaarBuilder) {
        bazaarBuilder.addAll(Activator.getDefault().getValidationDelegateProviders());
        return bazaarBuilder;
    }

    protected Bazaar.Builder<MarkerHelper> configureMarkers(Bazaar.Builder<MarkerHelper> bazaarBuilder) {
        bazaarBuilder.addAll(Activator.getDefault().getMarkerHelperProviders());
        return bazaarBuilder;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.getProject().deleteMarkers(MARKER_ID, true, 2);
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept((IResourceVisitor)new ResourceValidationVisitor(monitor));
        }
        catch (CoreException e) {
            Activator.log("Error running full build", e);
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new DeltaValidationVisitor(monitor));
    }

    protected BazaarContext createContext(IFile file) {
        BazaarContext.Builder result = BazaarContext.Builder.empty();
        result.put(IFile.class, (Object)file);
        IContentType contentType = this.getContentType(file);
        if (contentType != null) {
            result.put(IContentType.class, (Object)contentType);
            result.put("content-type", (Object)contentType.getId());
        }
        return result.build();
    }

    protected IContentType getContentType(IFile file) {
        IContentType result;
        try {
            IContentDescription contentDescription = file.getContentDescription();
            result = contentDescription == null ? null : contentDescription.getContentType();
        }
        catch (CoreException e) {
            result = null;
        }
        return result;
    }

    class DeltaValidationVisitor
    extends ValidationVisitor
    implements IResourceDeltaVisitor {
        DeltaValidationVisitor(IProgressMonitor monitor) {
            super(monitor);
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            switch (delta.getKind()) {
                case 1: 
                case 4: {
                    IResource resource = delta.getResource();
                    switch (resource.getType()) {
                        case 1: {
                            IFile file = (IFile)resource;
                            BazaarContext context = ValidationBuilder.this.createContext(file);
                            this.validate(file, context, this.getMonitor());
                        }
                    }
                    break;
                }
                case 2: {
                    break;
                }
            }
            return true;
        }
    }

    class ResourceValidationVisitor
    extends ValidationVisitor
    implements IResourceVisitor {
        ResourceValidationVisitor(IProgressMonitor monitor) {
            super(monitor);
        }

        public boolean visit(IResource resource) {
            boolean result;
            switch (resource.getType()) {
                case 1: {
                    IFile file = (IFile)resource;
                    BazaarContext context = ValidationBuilder.this.createContext(file);
                    this.validate(file, context, this.getMonitor());
                    result = false;
                    break;
                }
                default: {
                    result = true;
                }
            }
            return result;
        }
    }

    abstract class ValidationVisitor {
        private final IProgressMonitor monitor;
        private final Bazaar<ValidationDelegate> delegateBazaar;
        private final Bazaar<MarkerHelper> markerHelperBazaar;

        ValidationVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
            this.delegateBazaar = ValidationBuilder.this.configureValidation(ValidationBuilder.this.createBazaarBuilder(ValidationDelegateProvider.NULL)).build();
            this.markerHelperBazaar = ValidationBuilder.this.configureMarkers(ValidationBuilder.this.createBazaarBuilder(MarkerHelperProvider.DEFAULT)).build();
        }

        void validate(IFile file, BazaarContext context, IProgressMonitor monitor) {
            ValidationDelegate delegate = (ValidationDelegate)this.delegateBazaar.createProduct(context);
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            try {
                try {
                    Optional<Diagnostic> diagnostics = delegate.validate(file, (IProgressMonitor)sub.newChild(1));
                    if (diagnostics.isPresent()) {
                        Diagnostic diagnostic = (Diagnostic)diagnostics.get();
                        ValidationBuilder.this.projectMarkerHelper.deleteMarkers((Object)file);
                        if (diagnostic.getSeverity() >= 1) {
                            MarkerHelper markerHelper = (MarkerHelper)this.markerHelperBazaar.createProduct(context);
                            markerHelper.createMarkers(diagnostic);
                        }
                    }
                }
                catch (CoreException ex) {
                    Activator.log("Errors while creating markers on file " + file, ex);
                    sub.done();
                }
            }
            finally {
                sub.done();
            }
        }

        final IProgressMonitor getMonitor() {
            return this.monitor;
        }
    }
}

