/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.e4.editor;

import java.net.URL;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.edit.spi.EMFDeleteServiceImpl;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.ui.ECPDeleteServiceImpl;
import org.eclipse.emf.ecp.spi.ui.ECPReferenceServiceImpl;
import org.eclipse.emf.ecp.ui.internal.e4.Activator;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ECPE4Editor {
    public static final String INPUT = "ecpEditorInput";
    private MPart part;
    private EObject modelElement;
    private Adapter adapter;
    private final ScrolledComposite parent;

    @Inject
    public ECPE4Editor(Composite composite, Shell shell) {
        this.parent = new ScrolledComposite(composite, 768);
        this.parent.setBackground(shell.getDisplay().getSystemColor(1));
        this.parent.setBackgroundMode(2);
    }

    @Inject
    public void setInput(@Optional @Named(value="ecpEditorInput") EObject modelElement, MPart part, @Optional ECPProject ecpProject) {
        if (modelElement == null) {
            return;
        }
        this.part = part;
        this.modelElement = modelElement;
        ECPSWTView render = null;
        Object deleteService = ecpProject != null ? new ECPDeleteServiceImpl() : new EMFDeleteServiceImpl();
        try {
            VView view = ViewProviderHelper.getView((EObject)modelElement, null);
            ViewModelContext vmc = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)view, modelElement, new ViewModelService[]{new ECPReferenceServiceImpl(), deleteService});
            render = ECPSWTViewRenderer.INSTANCE.render((Composite)this.parent, vmc);
            this.parent.setExpandHorizontal(true);
            this.parent.setExpandVertical(true);
            this.parent.setContent(render.getSWTControl());
            this.parent.setMinSize(render.getSWTControl().computeSize(-1, -1));
        }
        catch (ECPRendererException ex) {
            Activator.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
        }
        this.updateImageAndText();
        this.adapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ECPE4Editor.this.updateImageAndText();
                    }
                });
            }
        };
        modelElement.eAdapters().add((Object)this.adapter);
    }

    @PreDestroy
    void dispose() {
        this.modelElement.eAdapters().remove((Object)this.adapter);
    }

    private void updateImageAndText() {
        Object uri;
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)InternalProvider.EMF_ADAPTER_FACTORY.adapt((Notifier)this.modelElement, IItemLabelProvider.class);
        this.part.setLabel(itemLabelProvider.getText((Object)this.modelElement));
        this.part.setTooltip(itemLabelProvider.getText((Object)this.modelElement));
        Object image = itemLabelProvider.getImage((Object)this.modelElement);
        String iconUri = null;
        if (ComposedImage.class.isInstance(image)) {
            ComposedImage composedImage = (ComposedImage)image;
            image = composedImage.getImages().get(0);
        }
        if (URI.class.isInstance(image)) {
            uri = (URI)image;
            iconUri = uri.toString();
        }
        if (URL.class.isInstance(image)) {
            uri = (URL)image;
            iconUri = ((URL)uri).toString();
        }
        this.part.setIconURI(iconUri);
    }

    @Focus
    void setFocus() {
        if (this.parent != null) {
            this.parent.setFocus();
        }
    }
}

