/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.spi.util;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.ide.internal.Activator;
import org.eclipse.emf.ecp.internal.ide.util.messages.Messages;

public final class EcoreHelper {
    private static final Map<String, String> ECOREPATH_TO_WORKSPACEURI = new HashMap<String, String>();
    private static final Map<String, Integer> ECOREPATH_TO_REGISTRATIONCOUNT = new HashMap<String, Integer>();
    private static final Map<String, Set<String>> WORKSPACEURI_REFERENCEDBY = new HashMap<String, Set<String>>();
    private static final Set<String> URIS_HOLD = new LinkedHashSet<String>();
    private static final Set<String> ALL_NSURIS_REGISTERED_BY_TOOLING = new HashSet<String>();
    private static final Map<String, EPackage> WORKSPACEURI_TO_REGISTEREDPACKAGE = new LinkedHashMap<String, EPackage>();

    private EcoreHelper() {
    }

    public static void registerEcore(String ecorePath) throws IOException {
        if (ecorePath == null) {
            return;
        }
        EMFFormsResourceSetImpl physicalResourceSet = new EMFFormsResourceSetImpl(ecorePath);
        EcoreHelper.initResourceSet((ResourceSet)physicalResourceSet, true);
        URI uri = URI.createPlatformResourceURI((String)ecorePath, (boolean)false);
        ECOREPATH_TO_WORKSPACEURI.put(ecorePath, uri.toString());
        ECOREPATH_TO_REGISTRATIONCOUNT.put(ecorePath, ECOREPATH_TO_REGISTRATIONCOUNT.getOrDefault(ecorePath, 0) + 1);
        Resource r = physicalResourceSet.createResource(uri);
        EcoreHelper.loadResource(ecorePath, r);
        EcoreUtil.resolveAll((ResourceSet)physicalResourceSet);
        if (WORKSPACEURI_REFERENCEDBY.containsKey(uri.toString())) {
            WORKSPACEURI_REFERENCEDBY.get(uri.toString()).remove(uri.toString());
        }
        EcoreHelper.convertRsToVirtual(ecorePath, (ResourceSet)physicalResourceSet);
    }

    private static void convertRsToVirtual(String ecorePath, ResourceSet physicalResourceSet) {
        ResourceSetImpl virtualResourceSet = new ResourceSetImpl();
        for (Resource physicalResource : physicalResourceSet.getResources()) {
            EPackage ePackage = EcoreHelper.getEPackage(physicalResource);
            if (ePackage == null) continue;
            if (EcoreHelper.isContainedInPackageRegistry(ePackage.getNsURI())) {
                if (!ALL_NSURIS_REGISTERED_BY_TOOLING.contains(ePackage.getNsURI())) {
                    Activator.log(1, String.format("Tooling Registered Packages don't contain package with URI %1$s.", ePackage.getNsURI()));
                    EcoreHelper.registerSubpackages(ePackage);
                    continue;
                }
                EPackage registeredPackage = EPackage.Registry.INSTANCE.getEPackage(ePackage.getNsURI());
                if (EcoreUtil.equals((EObject)ePackage, (EObject)registeredPackage)) {
                    Activator.log(1, String.format("Another package with same URI is already registered: %1$s.", registeredPackage));
                    EcoreHelper.registerSubpackages(ePackage);
                    continue;
                }
            }
            EcoreHelper.updateRegistryAndLocalCache(ePackage, physicalResource, (ResourceSet)virtualResourceSet);
        }
    }

    protected static void loadResource(String ecorePath, Resource resource) throws IOException {
        try {
            resource.load(null);
        }
        catch (IOException e) {
            if (e.getMessage().contains("does not exist")) {
                throw new IOException(MessageFormat.format(Messages.EcoreHelper_invalidEcorePath, ecorePath), e.getCause());
            }
            throw new IOException(MessageFormat.format(Messages.EcoreHelper_invalidEcore, ecorePath, e.getMessage()), e.getCause());
        }
    }

    private static EPackage getEPackage(Resource resource) {
        for (EObject eObject : resource.getContents()) {
            if (!(eObject instanceof EPackage)) continue;
            return (EPackage)eObject;
        }
        return null;
    }

    private static void updateRegistryAndLocalCache(EPackage ePackage, Resource oldResource, ResourceSet newResourceSet) {
        if (ePackage.getNsURI() == null || ePackage.getNsURI().isEmpty()) {
            Activator.log(2, String.format("Package does not have a valid Ns URI [%1$s].", ePackage));
            return;
        }
        String platformResourceURI = oldResource.getURI().toString();
        oldResource.getContents().remove((Object)ePackage);
        Resource virtualResource = newResourceSet.createResource(URI.createURI((String)ePackage.getNsURI()));
        virtualResource.getContents().add((Object)ePackage);
        EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
        ALL_NSURIS_REGISTERED_BY_TOOLING.add(ePackage.getNsURI());
        Activator.log(1, String.format("Registered Package with URI %1$s.", ePackage.getNsURI()));
        WORKSPACEURI_TO_REGISTEREDPACKAGE.put(platformResourceURI, ePackage);
        Activator.log(1, String.format("Mapped Package with URI %1$s to %2$s.", ePackage.getNsURI(), platformResourceURI));
        EcoreHelper.registerSubpackages(ePackage);
    }

    private static void registerSubpackages(EPackage ePackage) {
        for (EPackage subpackage : ePackage.getESubpackages()) {
            if (EPackage.Registry.INSTANCE.containsKey((Object)subpackage.getNsURI())) continue;
            EPackage.Registry.INSTANCE.put((Object)subpackage.getNsURI(), (Object)subpackage);
            Activator.log(1, String.format("Register subpackage %1$s of package %2$s.", subpackage.getNsURI(), ePackage.getNsURI()));
            EcoreHelper.registerSubpackages(subpackage);
        }
    }

    public static Set<String> getOtherRelatedWorkspacePaths(String ecorePath) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (ecorePath == null) {
            return result;
        }
        try {
            ResourceSetImpl physicalResourceSet = new ResourceSetImpl();
            EcoreHelper.initResourceSet((ResourceSet)physicalResourceSet, false);
            URI uri = URI.createPlatformResourceURI((String)ecorePath, (boolean)false);
            Resource tempResource = physicalResourceSet.createResource(uri);
            tempResource.load(null);
            EcoreUtil.resolveAll((ResourceSet)physicalResourceSet);
            for (Resource physicalResource : physicalResourceSet.getResources()) {
                if (physicalResource.getContents().size() == 0 || !physicalResource.getURI().isPlatformResource()) continue;
                result.add(physicalResource.getURI().toString());
            }
        }
        catch (IOException ex) {
            Activator.log(1, String.format("Error while loading %1$s.", ecorePath));
        }
        return result;
    }

    private static boolean isContainedInPackageRegistry(String nsURI) {
        EPackage.Registry instance = EPackage.Registry.INSTANCE;
        return instance.containsKey((Object)nsURI);
    }

    public static void unregisterEcore(String ecorePath) {
        if (ecorePath == null || !ECOREPATH_TO_WORKSPACEURI.containsKey(ecorePath)) {
            return;
        }
        ECOREPATH_TO_REGISTRATIONCOUNT.put(ecorePath, ECOREPATH_TO_REGISTRATIONCOUNT.getOrDefault(ecorePath, 1) - 1);
        if (ECOREPATH_TO_REGISTRATIONCOUNT.get(ecorePath) != 0) {
            return;
        }
        ECOREPATH_TO_REGISTRATIONCOUNT.remove(ecorePath);
        String uriToUnregister = ECOREPATH_TO_WORKSPACEURI.remove(ecorePath);
        Set<String> referencedBy = WORKSPACEURI_REFERENCEDBY.get(uriToUnregister);
        URIS_HOLD.add(uriToUnregister);
        if (ECOREPATH_TO_WORKSPACEURI.size() == 0) {
            URIS_HOLD.addAll(WORKSPACEURI_REFERENCEDBY.keySet());
        }
        LinkedHashSet<String> workspaceURIsToRemove = new LinkedHashSet<String>();
        boolean addedToDelete = false;
        if (referencedBy == null || referencedBy.size() == 0) {
            workspaceURIsToRemove.add(uriToUnregister);
            addedToDelete = true;
        } else if (URIS_HOLD.containsAll(referencedBy)) {
            for (String refed : referencedBy) {
                Set<String> toDeleteRefedBy = WORKSPACEURI_REFERENCEDBY.get(refed);
                if (!URIS_HOLD.containsAll(toDeleteRefedBy)) continue;
                workspaceURIsToRemove.add(refed);
                addedToDelete = true;
            }
            if (workspaceURIsToRemove.containsAll(referencedBy)) {
                workspaceURIsToRemove.add(uriToUnregister);
                addedToDelete = true;
            }
        }
        if (addedToDelete) {
            EcoreHelper.cleanAndRecheckRemovedURIs(workspaceURIsToRemove);
        }
        EcoreHelper.unregisterEcore(workspaceURIsToRemove);
    }

    private static void cleanAndRecheckRemovedURIs(Set<String> workspaceURIsToRemove) {
        boolean addedToDelete = true;
        while (addedToDelete) {
            addedToDelete = false;
            for (String toDelete : workspaceURIsToRemove) {
                URIS_HOLD.remove(toDelete);
                WORKSPACEURI_REFERENCEDBY.remove(toDelete);
                for (String key : WORKSPACEURI_REFERENCEDBY.keySet()) {
                    WORKSPACEURI_REFERENCEDBY.get(key).remove(toDelete);
                }
            }
            for (String uri : URIS_HOLD) {
                Set<String> toDeleteRefedBy = WORKSPACEURI_REFERENCEDBY.get(uri);
                if (toDeleteRefedBy != null && toDeleteRefedBy.size() != 0) continue;
                workspaceURIsToRemove.add(uri);
                addedToDelete = true;
            }
        }
    }

    private static void unregisterEcore(Set<String> workspaceURIsToRemove) {
        for (String toRemove : workspaceURIsToRemove) {
            EPackage pkgToRemove = WORKSPACEURI_TO_REGISTEREDPACKAGE.remove(toRemove);
            if (pkgToRemove == null) continue;
            EPackage.Registry.INSTANCE.remove((Object)pkgToRemove.getNsURI());
            ALL_NSURIS_REGISTERED_BY_TOOLING.remove(pkgToRemove.getNsURI());
            Activator.log(1, String.format("Unregister package %1$s.", pkgToRemove.getNsURI()));
            EcoreHelper.unregisterSubpackages(pkgToRemove);
        }
    }

    private static void unregisterSubpackages(EPackage ePackage) {
        for (EPackage subpackage : ePackage.getESubpackages()) {
            EPackage.Registry.INSTANCE.remove((Object)subpackage.getNsURI());
            Activator.log(1, String.format("Unregister subpackage %1$s of package %2$s.", subpackage.getNsURI(), ePackage.getNsURI()));
            EcoreHelper.unregisterSubpackages(subpackage);
        }
    }

    public static Object[] getDefaultPackageRegistryContents() {
        HashSet packages = new HashSet();
        packages.addAll(EPackage.Registry.INSTANCE.keySet());
        packages.removeAll(ALL_NSURIS_REGISTERED_BY_TOOLING);
        return packages.toArray();
    }

    private static void initResourceSet(ResourceSet resourceSet, boolean withLocalRegistry) {
        if (withLocalRegistry) {
            resourceSet.getPackageRegistry().putAll(WORKSPACEURI_TO_REGISTEREDPACKAGE);
            Activator.log(1, "Added map of platformuri to epackage to resourceset package registry.");
        }
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)true));
        resourceSet.getLoadOptions().put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
    }

    private static final class EMFFormsResourceSetImpl
    extends ResourceSetImpl {
        private final String ecorePath;

        private EMFFormsResourceSetImpl(String ecorePath) {
            this.ecorePath = ecorePath;
        }

        public Resource getResource(URI uri, boolean loadOnDemand) {
            Resource resource;
            if (uri.isPlatform()) {
                if (!WORKSPACEURI_REFERENCEDBY.containsKey(uri.toString())) {
                    WORKSPACEURI_REFERENCEDBY.put(uri.toString(), new LinkedHashSet());
                }
                ((Set)WORKSPACEURI_REFERENCEDBY.get(uri.toString())).add((String)ECOREPATH_TO_WORKSPACEURI.get(this.ecorePath));
            }
            if (this.resourceLocator != null) {
                return this.resourceLocator.getResource(uri, loadOnDemand);
            }
            Map map = this.getURIResourceMap();
            if (map != null && (resource = (Resource)map.get(uri)) != null) {
                if (loadOnDemand && !resource.isLoaded()) {
                    this.demandLoadHelper(resource);
                }
                return resource;
            }
            URIConverter theURIConverter = this.getURIConverter();
            URI normalizedURI = theURIConverter.normalize(uri);
            for (Resource resource2 : this.getResources()) {
                if (!theURIConverter.normalize(resource2.getURI()).equals(normalizedURI)) continue;
                if (loadOnDemand && !resource2.isLoaded()) {
                    this.demandLoadHelper(resource2);
                }
                if (map != null) {
                    map.put(uri, resource2);
                }
                return resource2;
            }
            Resource delegatedResource = this.delegatedGetResource(uri, loadOnDemand);
            if (delegatedResource != null) {
                if (map != null) {
                    map.put(uri, delegatedResource);
                }
                return delegatedResource;
            }
            if (loadOnDemand) {
                Resource resultResource;
                Resource resource3 = this.demandCreateResource(uri);
                if (resource3 == null) {
                    throw new RuntimeException("Cannot create a resource for '" + uri + "'; a registered resource factory is needed");
                }
                this.demandLoadHelper(resource3);
                Resource delegatedGetResource = this.delegatedGetResource(URI.createURI((String)((EPackage)resource3.getContents().get(0)).getNsURI()), loadOnDemand);
                Resource resource4 = resultResource = delegatedGetResource != null ? delegatedGetResource : resource3;
                if (delegatedGetResource != null) {
                    this.getResources().remove((Object)resource3);
                }
                if (map != null) {
                    map.put(uri, resultResource);
                }
                return resultResource;
            }
            return null;
        }
    }
}

