/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.view.model.localization;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.LocalizationAdapter;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VHasTooltip;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleChangeListener;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class LocalizationViewModelService
implements ViewModelService,
EMFFormsLocaleChangeListener {
    private EMFFormsLocaleProvider localeProvider;
    private ServiceReference<EMFFormsLocaleProvider> localeServiceReference;
    private BundleContext bundleContext;
    private VElement view;
    private ReportService reportService;
    private ServiceReference<ReportService> reportServiceReference;

    public LocalizationViewModelService() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle == null) {
            return;
        }
        this.bundleContext = bundle.getBundleContext();
        if (this.bundleContext == null) {
            return;
        }
        this.localeServiceReference = this.bundleContext.getServiceReference(EMFFormsLocaleProvider.class);
        if (this.localeServiceReference == null) {
            return;
        }
        this.localeProvider = (EMFFormsLocaleProvider)this.bundleContext.getService(this.localeServiceReference);
        this.reportServiceReference = this.bundleContext.getServiceReference(ReportService.class);
        this.reportService = (ReportService)this.bundleContext.getService(this.reportServiceReference);
        this.localeProvider.addEMFFormsLocaleChangeListener((EMFFormsLocaleChangeListener)this);
    }

    public void instantiate(ViewModelContext context) {
        this.view = context.getViewModel();
        final LocalizationAdapter adapter = this.getLocalizationAdapter(this.view);
        this.localizeView(adapter, this.view);
        context.registerViewChangeListener(new ModelChangeListener(){

            public void notifyChange(ModelChangeNotification notification) {
                if (notification.getRawNotification().getFeature() == VViewPackage.eINSTANCE.getElement_Name()) {
                    LocalizationViewModelService.this.localize(adapter, (VElement)notification.getNotifier());
                } else if (notification.getRawNotification().getEventType() == 3 || notification.getRawNotification().getEventType() == 5) {
                    for (EObject eObject : notification.getNewEObjects()) {
                        if (!VElement.class.isInstance(eObject)) continue;
                        LocalizationViewModelService.this.localize(adapter, (VElement)VElement.class.cast(eObject));
                        LocalizationViewModelService.this.checkContents(adapter, (VElement)VElement.class.cast(eObject));
                    }
                }
            }
        });
    }

    private void localizeView(LocalizationAdapter adapter, VElement view) {
        this.localize(adapter, view);
        this.checkContents(adapter, view);
    }

    private LocalizationAdapter getLocalizationAdapter(VElement view) {
        for (Adapter adapter : view.eAdapters()) {
            if (!LocalizationAdapter.class.isInstance(adapter)) continue;
            return (LocalizationAdapter)adapter;
        }
        return null;
    }

    private void checkContents(LocalizationAdapter adapter, VElement vElementRoot) {
        TreeIterator eAllContents = vElementRoot.eAllContents();
        while (eAllContents.hasNext()) {
            EObject eObject = (EObject)eAllContents.next();
            if (!VElement.class.isInstance(eObject)) continue;
            VElement vElement = (VElement)VElement.class.cast(eObject);
            this.localize(adapter, vElement);
        }
    }

    protected void localize(LocalizationAdapter localizationAdapter, VElement vElement) {
        VHasTooltip tooltip;
        if (vElement.getName() == null) {
            vElement.setLabel("");
        } else if (vElement.getName().startsWith("%")) {
            if (localizationAdapter != null) {
                vElement.setLabel(localizationAdapter.localize(vElement.getName().substring(1)));
            } else {
                this.reportAboutMissingLocalizationAdapter();
                vElement.setLabel(vElement.getName());
            }
        } else {
            vElement.setLabel(vElement.getName());
        }
        if (vElement instanceof VHasTooltip && (tooltip = (VHasTooltip)VHasTooltip.class.cast(vElement)).getTooltip() != null && tooltip.getTooltip().startsWith("%")) {
            if (localizationAdapter != null) {
                tooltip.setTooltip(localizationAdapter.localize(tooltip.getTooltip().substring(1)));
            } else {
                this.reportAboutMissingLocalizationAdapter();
            }
        }
    }

    private void reportAboutMissingLocalizationAdapter() {
        this.reportService.report(new AbstractReport("No LocalizationAdapter found for the current view:" + this.view.toString()));
    }

    public void dispose() {
        if (this.localeProvider != null) {
            this.localeProvider.removeEMFFormsLocaleChangeListener((EMFFormsLocaleChangeListener)this);
        }
        if (this.bundleContext != null && this.localeServiceReference != null) {
            this.bundleContext.ungetService(this.localeServiceReference);
        }
        if (this.bundleContext != null && this.reportServiceReference != null) {
            this.bundleContext.ungetService(this.reportServiceReference);
        }
    }

    public int getPriority() {
        return -100;
    }

    public void notifyLocaleChange() {
        LocalizationAdapter adapter = this.getLocalizationAdapter(this.view);
        this.localizeView(adapter, this.view);
    }
}

