/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.recorder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edapt.spi.history.History;

public class HistoryChangeRecorder {
    private final History history;
    private final EContentAdapter adapter;
    private boolean recording;
    private final List<Link> links = new ArrayList<Link>();

    public HistoryChangeRecorder(History history) {
        this.history = history;
        this.adapter = new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                switch (notification.getEventType()) {
                    case 1: {
                        HistoryChangeRecorder.this.handleSet(notification);
                    }
                }
                super.notifyChanged(notification);
            }
        };
        this.recording = false;
        this.beginRecording();
    }

    private void handleSet(Notification notification) {
        if (notification.getFeature() instanceof EReference) {
            EReference reference = (EReference)notification.getFeature();
            if (reference.isContainment()) {
                return;
            }
            EObject element = (EObject)notification.getNotifier();
            EObject oldValue = (EObject)notification.getOldValue();
            if (notification.getNewValue() == null && oldValue != null && oldValue.eClass().getEPackage() == EcorePackage.eINSTANCE) {
                Link link = new Link(element, reference, oldValue);
                this.links.add(link);
            }
        }
    }

    public void beginRecording() {
        if (this.isRecording()) {
            throw new IllegalStateException("Recorder is already started");
        }
        this.history.eAdapters().add((Object)this.adapter);
        this.recording = true;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void endRecording() {
        if (this.isRecording()) {
            this.history.eAdapters().remove((Object)this.adapter);
            for (Link link : this.links) {
                link.restore();
            }
        } else {
            throw new IllegalStateException("Recorder is already stopped");
        }
        this.recording = false;
    }

    private class Link {
        private final EObject element;
        private final EReference reference;
        private final EObject value;

        public Link(EObject element, EReference reference, EObject value) {
            this.element = element;
            this.reference = reference;
            this.value = value;
        }

        public void restore() {
            this.element.eSet((EStructuralFeature)this.reference, (Object)this.value);
        }
    }
}

