/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.spi.swt.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecp.edit.spi.swt.commands.IProgressMonitorProvider;
import org.eclipse.swt.widgets.Display;

public class ProgressCompoundCommand
extends CompoundCommand {
    private final IProgressMonitorProvider monitor;

    public ProgressCompoundCommand(int resultIndex, IProgressMonitorProvider monitor) {
        super(resultIndex);
        this.monitor = monitor;
    }

    public boolean isEmpty() {
        return this.commandList.isEmpty();
    }

    public List<Command> getCommandList() {
        return Collections.unmodifiableList(this.commandList);
    }

    public int getResultIndex() {
        return this.resultIndex;
    }

    protected boolean prepare() {
        if (this.commandList.isEmpty()) {
            return false;
        }
        for (Command command : this.commandList) {
            if (command.canExecute()) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            try {
                Command command = (Command)commands.next();
                command.execute();
                this.worked();
                continue;
            }
            catch (RuntimeException exception) {
                commands.previous();
                try {
                    while (commands.hasPrevious()) {
                        Command command = (Command)commands.previous();
                        if (command.canUndo()) {
                            command.undo();
                            this.worked();
                        }
                    }
                }
                catch (RuntimeException nestedException) {
                    CommonPlugin.INSTANCE.log((Object)new WrappedException(CommonPlugin.INSTANCE.getString("_UI_IgnoreException_exception"), (Exception)nestedException).fillInStackTrace());
                }
            }
            throw exception;
        }
    }

    public boolean canUndo() {
        for (Command command : this.commandList) {
            if (command.canUndo()) continue;
            return false;
        }
        return true;
    }

    public void undo() {
        ListIterator commands = this.commandList.listIterator(this.commandList.size());
        while (commands.hasPrevious()) {
            try {
                Command command = (Command)commands.previous();
                command.undo();
                this.worked();
                continue;
            }
            catch (RuntimeException exception) {
                commands.next();
                try {
                    while (commands.hasNext()) {
                        Command command = (Command)commands.next();
                        command.redo();
                        this.worked();
                    }
                }
                catch (RuntimeException nestedException) {
                    CommonPlugin.INSTANCE.log((Object)new WrappedException(CommonPlugin.INSTANCE.getString("_UI_IgnoreException_exception"), (Exception)nestedException).fillInStackTrace());
                }
            }
            throw exception;
        }
    }

    public void redo() {
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            try {
                Command command = (Command)commands.next();
                command.redo();
                this.worked();
                continue;
            }
            catch (RuntimeException exception) {
                commands.previous();
                try {
                    while (commands.hasPrevious()) {
                        Command command = (Command)commands.previous();
                        command.undo();
                        this.worked();
                    }
                }
                catch (RuntimeException nestedException) {
                    CommonPlugin.INSTANCE.log((Object)new WrappedException(CommonPlugin.INSTANCE.getString("_UI_IgnoreException_exception"), (Exception)nestedException).fillInStackTrace());
                }
            }
            throw exception;
        }
    }

    public Collection<?> getResult() {
        if (this.commandList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (this.resultIndex == Integer.MIN_VALUE) {
            return ((Command)this.commandList.get(this.commandList.size() - 1)).getResult();
        }
        if (this.resultIndex == Integer.MAX_VALUE) {
            return this.getMergedResultCollection();
        }
        if (this.resultIndex < this.commandList.size()) {
            return ((Command)this.commandList.get(this.resultIndex)).getResult();
        }
        return Collections.EMPTY_LIST;
    }

    protected Collection<?> getMergedResultCollection() {
        ArrayList result = new ArrayList();
        for (Command command : this.commandList) {
            result.addAll(command.getResult());
        }
        return result;
    }

    public Collection<?> getAffectedObjects() {
        if (this.commandList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (this.resultIndex == Integer.MIN_VALUE) {
            return ((Command)this.commandList.get(this.commandList.size() - 1)).getAffectedObjects();
        }
        if (this.resultIndex == Integer.MAX_VALUE) {
            return this.getMergedAffectedObjectsCollection();
        }
        if (this.resultIndex < this.commandList.size()) {
            return ((Command)this.commandList.get(this.resultIndex)).getAffectedObjects();
        }
        return Collections.EMPTY_LIST;
    }

    protected Collection<?> getMergedAffectedObjectsCollection() {
        ArrayList result = new ArrayList();
        for (Command command : this.commandList) {
            result.addAll(command.getAffectedObjects());
        }
        return result;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (this.commandList.isEmpty()) {
            return CommonPlugin.INSTANCE.getString("_UI_CompoundCommand_label");
        }
        if (this.resultIndex == Integer.MIN_VALUE || this.resultIndex == Integer.MAX_VALUE) {
            return ((Command)this.commandList.get(this.commandList.size() - 1)).getLabel();
        }
        if (this.resultIndex < this.commandList.size()) {
            return ((Command)this.commandList.get(this.resultIndex)).getLabel();
        }
        return CommonPlugin.INSTANCE.getString("_UI_CompoundCommand_label");
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        if (this.commandList.isEmpty()) {
            return CommonPlugin.INSTANCE.getString("_UI_CompoundCommand_description");
        }
        if (this.resultIndex == Integer.MIN_VALUE || this.resultIndex == Integer.MAX_VALUE) {
            return ((Command)this.commandList.get(this.commandList.size() - 1)).getDescription();
        }
        if (this.resultIndex < this.commandList.size()) {
            return ((Command)this.commandList.get(this.resultIndex)).getDescription();
        }
        return CommonPlugin.INSTANCE.getString("_UI_CompoundCommand_description");
    }

    public void append(Command command) {
        if (this.isPrepared) {
            throw new IllegalStateException("The command is already prepared");
        }
        if (command != null) {
            this.commandList.add(command);
        }
    }

    public boolean appendAndExecute(Command command) {
        if (command != null) {
            if (!this.isPrepared) {
                if (this.commandList.isEmpty()) {
                    this.isPrepared = true;
                    this.isExecutable = true;
                } else {
                    this.isExecutable = this.prepare();
                    this.isPrepared = true;
                    if (this.isExecutable) {
                        this.execute();
                    }
                }
            }
            if (command.canExecute()) {
                try {
                    command.execute();
                    this.worked();
                    this.commandList.add(command);
                    return true;
                }
                catch (RuntimeException exception) {
                    CommonPlugin.INSTANCE.log((Object)new WrappedException(CommonPlugin.INSTANCE.getString("_UI_IgnoreException_exception"), (Exception)exception).fillInStackTrace());
                }
            }
            command.dispose();
        }
        return false;
    }

    public boolean appendIfCanExecute(Command command) {
        if (command == null) {
            return false;
        }
        if (command.canExecute()) {
            this.commandList.add(command);
            return true;
        }
        command.dispose();
        return false;
    }

    public void dispose() {
        for (Command command : this.commandList) {
            command.dispose();
        }
    }

    public Command unwrap() {
        switch (this.commandList.size()) {
            case 0: {
                this.dispose();
                return UnexecutableCommand.INSTANCE;
            }
            case 1: {
                Command result = (Command)this.commandList.remove(0);
                this.dispose();
                return result;
            }
        }
        return this;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (commandList: #" + this.commandList.size() + ")");
        result.append(" (resultIndex: " + this.resultIndex + ")");
        return result.toString();
    }

    private void worked() {
        IProgressMonitor progressMonitor = this.monitor.getProgressMonitor();
        if (progressMonitor == null) {
            return;
        }
        progressMonitor.worked(1);
        while (Display.getDefault().readAndDispatch()) {
        }
    }
}

