/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.generalization;

import java.util.Collection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="generalizeSuperType", label="Generalize Super Type", description="In the metamodel, the super type of a class is replaced by its super types. In the model, the values of the features that the class inherits from that super type (excluding its super types) are deleted.")
public class GeneralizeSuperType
extends OperationImplementation {
    @EdaptParameter(main=true, description="The class of which the super type is replaced")
    public EClass eClass;
    @EdaptParameter(description="The super type to be replaced by its super types")
    public EClass superType;

    @EdaptConstraint(restricts="superType", description="The super type to remove actually has to be a super type")
    public boolean checkSuperType(EClass superType) {
        return this.eClass.getESuperTypes().contains((Object)superType);
    }

    @Override
    public void initialize(Metamodel metamodel) {
        if (!this.eClass.getESuperTypes().isEmpty()) {
            this.superType = (EClass)this.eClass.getESuperTypes().get(0);
        }
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        this.eClass.getESuperTypes().remove((Object)this.superType);
        this.eClass.getESuperTypes().addAll((Collection)this.superType.getESuperTypes());
        for (Instance instance : model.getAllInstances(this.eClass)) {
            for (EStructuralFeature feature : this.superType.getEStructuralFeatures()) {
                this.deleteFeatureValue(instance, feature);
            }
        }
    }
}

