/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.view.swt;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.EMFUtils;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.internal.edit.ECPControlHelper;
import org.eclipse.emf.ecp.spi.common.ui.CompositeFactory;
import org.eclipse.emf.ecp.spi.common.ui.SelectModelElementWizardFactory;
import org.eclipse.emf.ecp.spi.common.ui.composites.SelectionComposite;
import org.eclipse.emf.ecp.ui.view.swt.reference.AttachmentStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.EClassSelectionStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.EObjectSelectionStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.OpenInNewContextStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.ReferenceStrategy;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DefaultReferenceService
implements ReferenceService {
    private ViewModelContext context;
    private EObjectSelectionStrategy eobjectSelectionStrategy = EObjectSelectionStrategy.NULL;
    private EClassSelectionStrategy eclassSelectionStrategy = EClassSelectionStrategy.NULL;
    private AttachmentStrategy attachmentStrategy = AttachmentStrategy.DEFAULT;
    private ReferenceStrategy referenceStrategy = ReferenceStrategy.DEFAULT;
    private OpenInNewContextStrategy openInNewContextStrategy = OpenInNewContextStrategy.DEFAULT;

    public void instantiate(ViewModelContext context) {
        this.context = context;
    }

    public void dispose() {
    }

    public int getPriority() {
        return 2;
    }

    public void addNewModelElements(EObject eObject, EReference eReference) {
        EObject newMEInstance = this.getNewModelElementInstance(eObject, eReference);
        if (newMEInstance == null) {
            return;
        }
        if (eReference.isContainer()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Operation not permitted for container references!");
            return;
        }
        if (!eReference.isContainment()) {
            this.attachmentStrategy.addElementToModel(eObject, eReference, newMEInstance);
        }
        this.referenceStrategy.addElementsToReference(eObject, eReference, Collections.singleton(newMEInstance));
        this.openInNewContext(newMEInstance);
    }

    private EObject getNewModelElementInstance(EObject owner, EReference reference) {
        Collection<EClass> classes = this.eclassSelectionStrategy.collectEClasses(owner, reference, EMFUtils.getSubClasses((EClass)reference.getEReferenceType()));
        if (classes.isEmpty()) {
            String errorMessage = String.format("No concrete classes for the type %1$s were found!", reference.getEReferenceType().getName());
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)errorMessage);
            ((ReportService)this.context.getService(ReportService.class)).report(new AbstractReport(errorMessage));
            return null;
        }
        if (classes.size() == 1) {
            return EcoreUtil.create((EClass)classes.iterator().next());
        }
        return this.getModelElementInstanceFromList(classes);
    }

    private EObject getModelElementInstanceFromList(Collection<EClass> classes) {
        SelectionComposite helper = CompositeFactory.getSelectModelClassComposite(new HashSet(), new HashSet(), classes);
        return SelectModelElementWizardFactory.openCreateNewModelElementDialog((SelectionComposite)helper);
    }

    public void openInNewContext(EObject eObject) {
        EObject owner = eObject.eContainer();
        EReference reference = eObject.eContainmentFeature();
        this.openInNewContextStrategy.openInNewContext(owner, reference, eObject);
    }

    public void addExistingModelElements(EObject eObject, EReference eReference) {
        Iterator allElements = ItemPropertyDescriptor.getReachableObjectsOfType((EObject)eObject, (EClassifier)eReference.getEType()).iterator();
        LinkedHashSet<EObject> elements = new LinkedHashSet<EObject>();
        while (allElements.hasNext()) {
            elements.add((EObject)allElements.next());
        }
        elements = new LinkedHashSet<EObject>(this.eobjectSelectionStrategy.collectExistingObjects(eObject, eReference, elements));
        ECPControlHelper.removeExistingReferences((EObject)eObject, (EReference)eReference, elements);
        Set addedElements = SelectModelElementWizardFactory.openModelElementSelectionDialog(elements, (boolean)eReference.isMany());
        if (!addedElements.isEmpty()) {
            this.referenceStrategy.addElementsToReference(eObject, eReference, addedElements);
        }
    }

    void setEObjectSelectionStrategy(EObjectSelectionStrategy strategy) {
        if (strategy == null) {
            strategy = EObjectSelectionStrategy.NULL;
        }
        this.eobjectSelectionStrategy = strategy;
    }

    void setEClassSelectionStrategy(EClassSelectionStrategy strategy) {
        if (strategy == null) {
            strategy = EClassSelectionStrategy.NULL;
        }
        this.eclassSelectionStrategy = strategy;
    }

    void setAttachmentStrategy(AttachmentStrategy strategy) {
        if (strategy == null) {
            strategy = AttachmentStrategy.DEFAULT;
        }
        this.attachmentStrategy = strategy;
    }

    void setReferenceStrategy(ReferenceStrategy strategy) {
        if (strategy == null) {
            strategy = ReferenceStrategy.DEFAULT;
        }
        this.referenceStrategy = strategy;
    }

    void setOpenStrategy(OpenInNewContextStrategy strategy) {
        if (strategy == null) {
            strategy = OpenInNewContextStrategy.DEFAULT;
        }
        this.openInNewContextStrategy = strategy;
    }
}

