/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.ecore.swt.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.edit.spi.swt.reference.AddReferenceAction;
import org.eclipse.emf.ecp.internal.ui.Messages;
import org.eclipse.emf.ecp.spi.common.ui.CompositeFactory;
import org.eclipse.emf.ecp.spi.common.ui.CompositeProvider;
import org.eclipse.emf.ecp.spi.common.ui.SelectModelElementWizard;
import org.eclipse.emf.ecp.spi.common.ui.composites.SelectionComposite;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class AddEClassifierReferenceAction
extends AddReferenceAction {
    private final ReferenceService referenceService;
    private final Set<EPackage> ePackages;

    public AddEClassifierReferenceAction(EditingDomain editingDomain, EStructuralFeature.Setting setting, IItemPropertyDescriptor itemPropertyDescriptor, ReferenceService referenceService, Set<EPackage> packages) {
        super(editingDomain, setting, itemPropertyDescriptor, referenceService);
        this.referenceService = referenceService;
        this.ePackages = packages;
    }

    public void run() {
        EClassifier selectedClassifier = this.getExistingEClassifiers();
        if (selectedClassifier == null) {
            return;
        }
        this.referenceService.addNewModelElements((EObject)selectedClassifier, (EReference)this.getSetting().getEStructuralFeature());
    }

    private EClassifier getExistingEClassifiers() {
        Set<EClassifier> elements = this.getEClassifiersFromRegistry(this.ePackages);
        SelectModelElementWizard wizard = new SelectModelElementWizard("Select EClassifier", Messages.NewModelElementWizard_WizardTitle_AddModelElement, Messages.ModelelementSelectionDialog_DialogTitle, Messages.ModelelementSelectionDialog_DialogMessage_SearchPattern, EObject.class);
        SelectionComposite tableSelectionComposite = CompositeFactory.getTableSelectionComposite((Object)elements.toArray(), (boolean)false);
        wizard.setCompositeProvider((CompositeProvider)tableSelectionComposite);
        WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        EClassifier eClassifier = null;
        int result = wd.open();
        if (result == 0) {
            Object[] selection = tableSelectionComposite.getSelection();
            if (selection == null || selection.length == 0) {
                return null;
            }
            eClassifier = (EClassifier)selection[0];
        }
        return eClassifier;
    }

    protected Set<EClassifier> getEClassifiersFromRegistry(Set<EPackage> ePackages) {
        HashSet<EClassifier> elements = new HashSet<EClassifier>();
        for (EPackage ePackage : ePackages) {
            elements.addAll((Collection<EClassifier>)ePackage.getEClassifiers());
        }
        return elements;
    }
}

