/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.simple;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="moveClassifier", label="Move Classifier", description="In the metamodel, a classifier is moved to a different package. In the model, nothing is changed.", breaking=true)
public class MoveClassifier
extends OperationImplementation {
    @EdaptParameter(main=true, description="The classifier to be moved")
    public EClassifier classifier;
    @EdaptParameter(description="The package to which the classifier is moved")
    public EPackage targetPackage;

    @EdaptConstraint(description="A classifier with the same name exists in the target package")
    public boolean checkUniqueClassifierNameInTargetPackage() {
        return this.targetPackage == null || this.targetPackage.getEClassifier(this.classifier.getName()) == null;
    }

    @EdaptConstraint(description="The classifier must not be already part of the target package")
    public boolean checkClassifierNotInTargetPackage() {
        return this.classifier.getEPackage() != this.targetPackage;
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        this.targetPackage.getEClassifiers().add((Object)this.classifier);
    }
}

