/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public final class EMFUtils {
    private EMFUtils() {
    }

    public static Collection<EClass> getSubClasses(EClass superClass) {
        HashSet<EClass> classes = new HashSet<EClass>();
        for (EPackage ePackage : EMFUtils.getAllRegisteredEPackages()) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract() || eClass.isInterface() || EcorePackage.eINSTANCE.getEObject() != superClass && !superClass.isSuperTypeOf(eClass)) continue;
                classes.add(eClass);
            }
        }
        return classes;
    }

    public static Set<EPackage> getAllRegisteredEPackages() {
        HashSet<EPackage> ePackages = new HashSet<EPackage>();
        LinkedHashSet namespaceURIs = new LinkedHashSet(EPackage.Registry.INSTANCE.keySet());
        for (String nsURI : namespaceURIs) {
            EPackage ePackage;
            try {
                ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
            }
            catch (Exception ex) {
                continue;
            }
            if (ePackage == null) continue;
            ePackages.add(ePackage);
        }
        return ePackages;
    }

    public static boolean filteredEquals(EObject property, EObject other, EStructuralFeature ... filteredFeatures) {
        if (property == null) {
            return other == null;
        }
        if (other == null) {
            return false;
        }
        if (property.eClass() != other.eClass()) {
            return false;
        }
        List<EStructuralFeature> filter = Arrays.asList(filteredFeatures);
        for (EStructuralFeature esf : property.eClass().getEAllStructuralFeatures()) {
            if (filter.contains(esf) || EMFUtils.equalFeature(property, other, esf)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalFeature(EObject eObject1, EObject eObject2, EStructuralFeature structuralFeature) {
        if (structuralFeature.isUnsettable() && eObject1.eIsSet(structuralFeature) != eObject2.eIsSet(structuralFeature)) {
            return false;
        }
        if (eObject1.eGet(structuralFeature) == null) {
            return eObject2.eGet(structuralFeature) == null;
        }
        return eObject1.eGet(structuralFeature).equals(eObject2.eGet(structuralFeature));
    }
}

