/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.table;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emfforms.common.Feature;
import org.eclipse.emfforms.spi.swt.table.AbstractFeatureAwareBuilder;
import org.eclipse.emfforms.spi.swt.table.TableConfiguration;
import org.eclipse.emfforms.spi.swt.table.TableConfigurationImpl;

public final class TableConfigurationBuilder
extends AbstractFeatureAwareBuilder<TableConfigurationBuilder> {
    private final Set<Feature> features = new LinkedHashSet<Feature>();
    private final Map<String, Object> data = new LinkedHashMap<String, Object>();

    private TableConfigurationBuilder() {
    }

    public static TableConfigurationBuilder usingDefaults() {
        return new TableConfigurationBuilder();
    }

    public static TableConfigurationBuilder usingConfiguration(TableConfiguration tableConfiguration) {
        return new TableConfigurationBuilder(tableConfiguration);
    }

    private TableConfigurationBuilder(TableConfiguration tableConfiguration) {
        this.features.addAll(tableConfiguration.getEnabledFeatures());
    }

    @Override
    public Set<Feature> getSupportedFeatures() {
        return new LinkedHashSet<Feature>(Arrays.asList(TableConfiguration.FEATURES));
    }

    @Override
    protected Set<Feature> getEnabledFeatures() {
        return this.features;
    }

    public TableConfigurationBuilder dataMapEntry(String key, Object value) {
        this.data.put(key, value);
        return this;
    }

    public TableConfiguration build() {
        TableConfigurationImpl config = new TableConfigurationImpl(this.features, this.data);
        return config;
    }
}

