/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.core.swt;

import java.util.concurrent.TimeUnit;

public class TimeBoundStringBuffer {
    private static final long DEFAULT_TIMEOUT = TimeUnit.MILLISECONDS.toMillis(1000L);
    private final StringBuffer searchBuffer = new StringBuffer();
    private final long timeout;
    private long lastKeyPressMillis = -1L;

    public TimeBoundStringBuffer() {
        this(DEFAULT_TIMEOUT);
    }

    public TimeBoundStringBuffer(long bound) {
        this.timeout = bound;
    }

    public void addLast(Character character) {
        this.searchBuffer.append(Character.toString(character.charValue()));
        this.resetKeyPressedTimeout();
    }

    public void removeLast() {
        if (this.searchBuffer.length() > 0) {
            this.searchBuffer.deleteCharAt(this.searchBuffer.length() - 1);
            this.resetKeyPressedTimeout();
        }
    }

    public void reset() {
        this.searchBuffer.setLength(0);
        this.resetKeyPressedTimer();
    }

    public void resetIfTimedOut() {
        if (this.timedOut()) {
            this.reset();
        }
    }

    public boolean isEmpty() {
        return this.searchBuffer.length() == 0;
    }

    public String asString() {
        return this.searchBuffer.toString();
    }

    public boolean timedOut() {
        long timeElapsed = -1L;
        if (this.lastKeyPressMillis > 0L) {
            timeElapsed = System.currentTimeMillis() - this.lastKeyPressMillis;
        }
        return timeElapsed != -1L && timeElapsed > this.timeout;
    }

    protected void resetKeyPressedTimer() {
        this.lastKeyPressMillis = -1L;
    }

    protected void resetKeyPressedTimeout() {
        this.lastKeyPressMillis = System.currentTimeMillis();
    }
}

