/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.group.swt.internal.collapsable;

import javax.inject.Inject;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.ContainerSWTRenderer;
import org.eclipse.emf.ecp.view.spi.group.model.VGroup;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.layout.EMFFormsSWTLayoutUtil;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Widget;

public class CollapsableGroupSWTRenderer
extends ContainerSWTRenderer<VGroup> {
    private static final int MARGIN = 5;
    private SWTGridDescription rendererGridDescription;
    private final EMFDataBindingContext dbc = new EMFDataBindingContext();

    @Inject
    public CollapsableGroupSWTRenderer(VGroup vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsRendererFactory factory) {
        super((VElement)vElement, viewContext, reportService, factory);
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
            SWTGridCell swtGridCell = (SWTGridCell)this.rendererGridDescription.getGrid().get(0);
            swtGridCell.setVerticalFill(false);
            swtGridCell.setVerticalGrab(false);
        }
        return this.rendererGridDescription;
    }

    protected Control renderControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        final CollapsableGroupExpandBar bar = new CollapsableGroupExpandBar(parent, 0);
        bar.setBackground(parent.getBackground());
        final Composite composite = new Composite((Composite)bar, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(composite);
        final ExpandItem item0 = new ExpandItem((ExpandBar)bar, 0, 0);
        bar.setInitialHeaderHeight(item0.getHeaderHeight());
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)bar.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)bar.getDisplay());
        bar.setFont(boldFont);
        ISWTObservableValue target = WidgetProperties.text().observe((Widget)item0);
        IObservableValue modelValue = EMFEditObservables.observeValue((EditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getVElement()), (EObject)this.getVElement(), (EStructuralFeature)VViewPackage.eINSTANCE.getElement_Label());
        this.dbc.bindValue((IObservableValue)target, modelValue);
        Control containerControl = super.renderControl(gridCell, composite);
        GridDataFactory.fillDefaults().grab(true, false).minSize(containerControl.computeSize((int)-1, (int)-1).x, -1).applyTo(containerControl);
        int height = this.computeHeight(composite);
        item0.setHeight(height);
        item0.setControl((Control)composite);
        bar.setItemComposite(composite);
        bar.addExpandListener(new ExpandListener(){

            public void itemCollapsed(ExpandEvent e) {
                int headerHeight = item0.getHeaderHeight();
                item0.setHeight(headerHeight);
                Object layoutData = bar.getLayoutData();
                this.updateLayoutData(layoutData, headerHeight + 10);
                EMFFormsSWTLayoutUtil.adjustParentSize((Control)bar);
                ((VGroup)CollapsableGroupSWTRenderer.this.getVElement()).setCollapsed(true);
                CollapsableGroupSWTRenderer.this.postCollapsed();
            }

            public void itemExpanded(ExpandEvent e) {
                item0.setHeight(CollapsableGroupSWTRenderer.this.computeHeight(composite));
                Object layoutData = bar.getLayoutData();
                this.updateLayoutData(layoutData, CollapsableGroupSWTRenderer.this.computeHeight(composite) + item0.getHeaderHeight() + 10);
                EMFFormsSWTLayoutUtil.adjustParentSize((Control)bar);
                ((VGroup)CollapsableGroupSWTRenderer.this.getVElement()).setCollapsed(false);
                CollapsableGroupSWTRenderer.this.postExpanded();
            }

            private void updateLayoutData(Object layoutData, int height) {
                if (layoutData instanceof GridData) {
                    GridData gridData = (GridData)layoutData;
                    gridData.heightHint = height;
                }
            }
        });
        item0.setExpanded(!((VGroup)this.getVElement()).isCollapsed());
        return bar;
    }

    protected void postExpanded() {
    }

    protected void postCollapsed() {
    }

    private int computeHeight(Composite composite) {
        return composite.computeSize((int)-1, (int)-1).y + 1;
    }

    protected void dispose() {
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        super.dispose();
    }

    private static final class CollapsableGroupExpandBar
    extends ExpandBar {
        private Composite itemComposite;
        private int headerHeight;

        CollapsableGroupExpandBar(Composite parent, int style) {
            super(parent, style);
        }

        void setInitialHeaderHeight(int headerHeight) {
            this.headerHeight = headerHeight;
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            return this.computeSizeForBar(wHint, hHint, changed);
        }

        protected void checkSubclass() {
        }

        void setItemComposite(Composite itemComposite) {
            this.itemComposite = itemComposite;
        }

        private Point computeSizeForBar(int wHint, int hHint, boolean changed) {
            Point sizeComputedByBar = super.computeSize(wHint, hHint, changed);
            if (this.itemComposite != null) {
                Point itemSize = this.itemComposite.computeSize(wHint, hHint, changed);
                if (itemSize.x > sizeComputedByBar.x) {
                    sizeComputedByBar.x = itemSize.x;
                }
                if (this.getItemCount() == 1 && this.getItem(0).getHeaderHeight() < 0 && itemSize.y + this.headerHeight > sizeComputedByBar.y && this.getItem(0).getExpanded()) {
                    sizeComputedByBar.y = itemSize.y + this.headerHeight;
                }
            }
            sizeComputedByBar.x += 10;
            return sizeComputedByBar;
        }
    }
}

