/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.treemasterdetail;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.internal.databinding.observable.DelayedObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.common.callback.ViewModelPropertiesUpdateCallback;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.swt.masterdetail.DetailViewCache;
import org.eclipse.emf.ecp.view.spi.swt.masterdetail.DetailViewManager;
import org.eclipse.emf.ecp.view.spi.swt.selection.IMasterDetailSelectionProvider;
import org.eclipse.emf.ecp.view.spi.swt.selection.MasterDetailFocusAdapter;
import org.eclipse.emf.ecp.view.spi.swt.selection.MasterDetailSelectionProvider;
import org.eclipse.emf.ecp.view.treemasterdetail.model.VTreeMasterDetail;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emfforms.spi.core.services.reveal.EMFFormsRevealService;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailCache;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailSWTCustomization;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeViewerSWTFactory;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeWidthProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.DetailPanelRenderingFinishedCallback;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.RootObject;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class TreeMasterDetailComposite
extends Composite
implements IEditingDomainProvider {
    private final Object input;
    private final EditingDomain editingDomain;
    private TreeViewer treeViewer;
    private IMasterDetailSelectionProvider selectionProvider;
    private Sash verticalSash;
    private Composite detailComposite;
    private DetailViewManager detailManager;
    private final String selectNodeMessage = LocalizationServiceHelper.getString(((Object)((Object)this)).getClass(), (String)"selectNodeMessage");
    private final String loadingMessage = LocalizationServiceHelper.getString(((Object)((Object)this)).getClass(), (String)"loadingMessage");
    private Object lastRenderedObject;
    private final TreeMasterDetailSWTCustomization customization;
    private final int renderDelay;
    private ViewModelPropertiesUpdateCallback viewModelPropertiesUpdateCallback;
    private final Set<DetailPanelRenderingFinishedCallback> detailPanelRenderingFinishedCallbacks = new LinkedHashSet<DetailPanelRenderingFinishedCallback>();

    TreeMasterDetailComposite(Composite parent, int style, Object input, TreeMasterDetailSWTCustomization customization, int renderDelay) {
        super(parent, style);
        this.input = input;
        this.editingDomain = input instanceof Resource ? AdapterFactoryEditingDomain.getEditingDomainFor((EObject)((EObject)((Resource)input).getContents().get(0))) : (input instanceof RootObject ? AdapterFactoryEditingDomain.getEditingDomainFor((EObject)((RootObject)RootObject.class.cast(input)).getRoot()) : AdapterFactoryEditingDomain.getEditingDomainFor((Object)input));
        this.renderDelay = renderDelay;
        this.customization = customization;
        this.renderControl(customization);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TreeMasterDetailComposite.this.dispose();
            }
        });
    }

    private Control renderControl(TreeMasterDetailSWTCustomization buildBehaviour) {
        this.setLayout((Layout)new FormLayout());
        this.verticalSash = this.createSash(this, buildBehaviour);
        Composite treeComposite = new Composite((Composite)this, 0);
        this.addTreeViewerLayoutData(treeComposite, this.verticalSash);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(treeComposite);
        this.treeViewer = TreeViewerSWTFactory.createTreeViewer(treeComposite, this.input, this.customization);
        this.selectionProvider = new MasterDetailSelectionProvider((ISelectionProvider)this.treeViewer);
        this.treeViewer.getControl().addFocusListener((FocusListener)new MasterDetailFocusAdapter(this.selectionProvider, () -> this.detailManager.getDetailContainer()));
        this.detailComposite = buildBehaviour.createDetailComposite(this);
        this.addDetailCompositeLayoutData(this.detailComposite, this.verticalSash);
        Composite detailParent = this.detailComposite;
        if (detailParent instanceof ScrolledComposite) {
            Composite detailPanel = new Composite(detailParent, 2048);
            ((ScrolledComposite)detailParent).setContent((Control)detailPanel);
            detailParent = detailPanel;
        }
        this.detailManager = new DetailViewManager(detailParent);
        this.detailManager.setNoDetailMessage(this.selectNodeMessage);
        this.detailManager.layoutDetailParent(detailParent);
        IViewerObservableValue treeViewerSelectionObservable = ViewersObservables.observeSingleSelection((Viewer)this.treeViewer);
        if (this.renderDelay > 0) {
            treeViewerSelectionObservable = new DelayedObservableValue(this.renderDelay, (IObservableValue)treeViewerSelectionObservable);
        }
        treeViewerSelectionObservable.addChangeListener(__ -> this.doUpdateDetailPanel(false));
        IViewerObservableValue observableToDispose = treeViewerSelectionObservable;
        treeComposite.addDisposeListener(arg_0 -> TreeMasterDetailComposite.lambda$2((IObservableValue)observableToDispose, arg_0));
        this.treeViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 10) {
                    TreeMasterDetailComposite.this.doUpdateDetailPanel(true);
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeMasterDetailComposite.this.doUpdateDetailPanel(true);
            }
        });
        this.updateDetailPanel(false);
        return this;
    }

    private void setFocusToDetail() {
        this.detailManager.setFocus();
    }

    private void addDetailCompositeLayoutData(Composite detailComposite, Sash verticalSash) {
        FormData detailFormData = new FormData();
        detailFormData.left = new FormAttachment((Control)verticalSash, 2);
        detailFormData.top = new FormAttachment(0, 5);
        detailFormData.bottom = new FormAttachment(100, -5);
        detailFormData.right = new FormAttachment(100, -5);
        detailComposite.setLayoutData((Object)detailFormData);
    }

    private void addTreeViewerLayoutData(Composite treeComposite, Sash verticalSash) {
        FormData treeFormData = new FormData();
        treeFormData.bottom = new FormAttachment(100, -5);
        treeFormData.left = new FormAttachment(0, 5);
        treeFormData.right = new FormAttachment((Control)verticalSash, -2);
        treeFormData.top = new FormAttachment(0, 5);
        treeComposite.setLayoutData((Object)treeFormData);
    }

    private Sash createSash(final Composite parent, TreeWidthProvider buildBehaviour) {
        final Sash sash = new Sash(parent, 512);
        FormData sashFormData = new FormData();
        sashFormData.bottom = new FormAttachment(100, -5);
        sashFormData.left = new FormAttachment(0, buildBehaviour.getInitialTreeWidth());
        sashFormData.top = new FormAttachment(0, 5);
        sash.setLayoutData((Object)sashFormData);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                sash.setLocation(e.x, e.y);
                FormData sashFormData = new FormData();
                sashFormData.bottom = new FormAttachment(100, -5);
                sashFormData.left = new FormAttachment(0, e.x);
                sashFormData.top = new FormAttachment(0, 5);
                sash.setLayoutData((Object)sashFormData);
                parent.layout(true);
            }
        });
        return sash;
    }

    public void updateDetailPanel(boolean setFocusToDetail) {
        StructuredSelection selection = (StructuredSelection)this.treeViewer.getSelection();
        Object selectedObject = this.getSelectedObject((IStructuredSelection)selection);
        this.detailManager.cacheCurrentDetail();
        boolean asyncRendering = false;
        if (selectedObject instanceof EObject) {
            this.lastRenderedObject = selectedObject;
            EObject eObject = (EObject)EObject.class.cast(selectedObject);
            if (this.detailManager.isCached(eObject)) {
                this.detailManager.activate(eObject);
                this.updateScrolledComposite();
            } else {
                VView view;
                if (this.viewModelPropertiesUpdateCallback != null) {
                    this.viewModelPropertiesUpdateCallback.updateViewModelProperties(this.detailManager.getDetailProperties());
                }
                if ((view = this.detailManager.getDetailView(eObject)).getChildren().size() > 0 && view.getChildren().get(0) instanceof VTreeMasterDetail) {
                    VTreeMasterDetail vTreeMasterDetail = (VTreeMasterDetail)view.getChildren().get(0);
                    ViewModelContext context = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)vTreeMasterDetail.getDetailView(), eObject);
                    this.detailManager.render(context, (arg_0, arg_1) -> ((ECPSWTViewRenderer)ECPSWTViewRenderer.INSTANCE).render(arg_0, arg_1));
                } else {
                    this.detailManager.setNoDetailMessage(this.loadingMessage);
                    asyncRendering = true;
                    Display.getDefault().asyncExec((Runnable)new UpdateDetailRunnable(setFocusToDetail, eObject));
                }
                this.updateScrolledComposite();
            }
        } else {
            this.renderEmptyDetailPanel();
        }
        if (!asyncRendering) {
            for (DetailPanelRenderingFinishedCallback callback : this.detailPanelRenderingFinishedCallbacks) {
                callback.renderingFinished(selectedObject);
            }
        }
    }

    private Object getSelectedObject(IStructuredSelection selection) {
        Object selectedObject;
        Object object = selectedObject = selection != null ? selection.getFirstElement() : null;
        if (this.customization.enableVerticalCopy() && selectedObject instanceof EObject && selection.size() > 1) {
            boolean allOfSameType = true;
            EObject dummy = EcoreUtil.create((EClass)((EObject)selectedObject).eClass());
            Iterator iterator = selection.iterator();
            LinkedHashSet<EObject> selectedEObjects = new LinkedHashSet<EObject>();
            while (iterator.hasNext()) {
                EObject eObject = (EObject)iterator.next();
                if (!(allOfSameType &= eObject.eClass() == dummy.eClass())) break;
                for (EAttribute attribute : dummy.eClass().getEAllAttributes()) {
                    if (eObject == selectedObject) {
                        dummy.eSet((EStructuralFeature)attribute, eObject.eGet((EStructuralFeature)attribute));
                        continue;
                    }
                    if (dummy.eGet((EStructuralFeature)attribute) == null || dummy.eGet((EStructuralFeature)attribute).equals(eObject.eGet((EStructuralFeature)attribute))) continue;
                    dummy.eUnset((EStructuralFeature)attribute);
                }
                selectedEObjects.add(eObject);
            }
            if (allOfSameType) {
                selectedObject = dummy;
                dummy.eAdapters().add((Object)new MultiEditAdapter(selectedEObjects, dummy));
            }
        }
        return selectedObject;
    }

    private void updateScrolledComposite() {
        if (ScrolledComposite.class.isInstance(this.detailComposite)) {
            ((ScrolledComposite)ScrolledComposite.class.cast(this.detailComposite)).setMinSize(this.detailManager.getDetailContainer().computeSize(-1, -1));
        }
    }

    private void renderEmptyDetailPanel() {
        this.lastRenderedObject = null;
        this.detailManager.cacheCurrentDetail();
        this.updateScrolledComposite();
    }

    public void dispose() {
        this.detailManager.dispose();
        this.customization.dispose();
        super.dispose();
    }

    public Object getCurrentSelection() {
        if (!(this.treeViewer.getSelection() instanceof StructuredSelection)) {
            return null;
        }
        return ((StructuredSelection)this.treeViewer.getSelection()).getFirstElement();
    }

    public void setSelection(ISelection structuredSelection) {
        this.treeViewer.setSelection(structuredSelection);
    }

    @Deprecated
    public TreeViewer getSelectionProvider() {
        return this.treeViewer;
    }

    public ISelectionProvider getMasterDetailSelectionProvider() {
        return this.selectionProvider;
    }

    public void refresh() {
        if (this.treeViewer != null) {
            this.treeViewer.refresh();
        }
    }

    public boolean selectAndReveal(Object selection) {
        EStructuralFeature feature;
        UniqueSetting setting;
        boolean result = false;
        Object toReveal = selection;
        if (selection instanceof UniqueSetting) {
            setting = (UniqueSetting)selection;
            toReveal = setting.getEObject();
            feature = setting.getEStructuralFeature();
        } else if (selection instanceof EStructuralFeature.Setting) {
            setting = (EStructuralFeature.Setting)selection;
            toReveal = setting.getEObject();
            feature = setting.getEStructuralFeature();
        } else {
            feature = null;
        }
        if (feature != null) {
            CompletableFuture<ECPSWTView> renderedDetail = new CompletableFuture<ECPSWTView>();
            DetailPanelRenderingFinishedCallback detailReady = __ -> {
                boolean bl = renderedDetail.complete(this.detailManager.getCurrentDetail());
            };
            this.registerDetailPanelRenderingFinishedCallback(detailReady);
            EObject owner = (EObject)toReveal;
            result = this.selectAndRevealInTree(owner);
            if (result) {
                renderedDetail.whenComplete((view, e) -> {
                    this.unregisterDetailPanelRenderingFinishedCallback(detailReady);
                    this.revealInDetail((ECPSWTView)view, owner, feature);
                });
            } else {
                renderedDetail.cancel(false);
                this.unregisterDetailPanelRenderingFinishedCallback(detailReady);
            }
            ECPSWTView currentDetail = this.detailManager.getCurrentDetail();
            if (currentDetail != null && currentDetail.getViewModelContext().getDomainModel() == owner) {
                renderedDetail.complete(currentDetail);
            }
        } else {
            result = this.selectAndRevealInTree(toReveal);
        }
        return result;
    }

    private boolean selectAndRevealInTree(Object selection) {
        if (this.treeViewer == null) {
            return false;
        }
        boolean result = false;
        Object objectToReveal = selection;
        while (objectToReveal != null) {
            this.treeViewer.reveal(objectToReveal);
            if (this.treeViewer.testFindItem(objectToReveal) != null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection(objectToReveal));
                result = objectToReveal == selection;
                break;
            }
            objectToReveal = ((ITreeContentProvider)this.treeViewer.getContentProvider()).getParent(objectToReveal);
        }
        return result;
    }

    private void revealInDetail(ECPSWTView detail, EObject object, EStructuralFeature feature) {
        ViewModelContext context = detail.getViewModelContext();
        if (!context.hasService(EMFFormsRevealService.class)) {
            return;
        }
        EMFFormsRevealService reveal = (EMFFormsRevealService)context.getService(EMFFormsRevealService.class);
        reveal.reveal(object, feature);
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setInput(Object input) {
        this.treeViewer.setInput(input);
    }

    @Deprecated
    public void setCache(TreeMasterDetailCache cache) {
        this.setCache((DetailViewCache)cache);
    }

    public void setCache(DetailViewCache cache) {
        this.detailManager.setCache(cache);
    }

    private void doUpdateDetailPanel(boolean setFocusToDetail) {
        if (this.lastRenderedObject == this.getCurrentSelection()) {
            if (setFocusToDetail) {
                this.setFocusToDetail();
            }
            return;
        }
        this.updateDetailPanel(setFocusToDetail);
    }

    public void addViewModelPropertiesUpdateCallback(ViewModelPropertiesUpdateCallback viewModelPropertiesUpdateCallback) {
        this.viewModelPropertiesUpdateCallback = viewModelPropertiesUpdateCallback;
    }

    public boolean registerDetailPanelRenderingFinishedCallback(DetailPanelRenderingFinishedCallback detailPanelRenderingFinishedCallback) {
        return this.detailPanelRenderingFinishedCallbacks.add(detailPanelRenderingFinishedCallback);
    }

    public boolean unregisterDetailPanelRenderingFinishedCallback(DetailPanelRenderingFinishedCallback detailPanelRenderingFinishedCallback) {
        return this.detailPanelRenderingFinishedCallbacks.remove(detailPanelRenderingFinishedCallback);
    }

    private static /* synthetic */ void lambda$2(IObservableValue iObservableValue, DisposeEvent __) {
        iObservableValue.dispose();
    }

    private final class MultiEditAdapter
    extends AdapterImpl {
        private final Set<EObject> selectedEObjects;
        private final EObject dummy;

        private MultiEditAdapter(Set<EObject> selectedEObjects, EObject dummy) {
            this.selectedEObjects = selectedEObjects;
            this.dummy = dummy;
        }

        public void notifyChanged(Notification notification) {
            if (this.dummy.eClass().getEAllAttributes().contains(notification.getFeature())) {
                CompoundCommand cc = new CompoundCommand();
                block6: for (EObject selected : this.selectedEObjects) {
                    Command command = null;
                    switch (notification.getEventType()) {
                        case 1: {
                            command = SetCommand.create((EditingDomain)TreeMasterDetailComposite.this.editingDomain, (Object)selected, (Object)notification.getFeature(), (Object)notification.getNewValue());
                            break;
                        }
                        case 2: {
                            command = SetCommand.create((EditingDomain)TreeMasterDetailComposite.this.editingDomain, (Object)selected, (Object)notification.getFeature(), (Object)SetCommand.UNSET_VALUE);
                            break;
                        }
                        case 3: 
                        case 5: {
                            command = AddCommand.create((EditingDomain)TreeMasterDetailComposite.this.editingDomain, (Object)selected, (Object)notification.getFeature(), (Object)notification.getNewValue());
                            break;
                        }
                        case 4: 
                        case 6: {
                            command = DeleteCommand.create((EditingDomain)TreeMasterDetailComposite.this.editingDomain, (Object)notification.getOldValue());
                            break;
                        }
                        default: {
                            continue block6;
                        }
                    }
                    cc.append(command);
                }
                TreeMasterDetailComposite.this.editingDomain.getCommandStack().execute((Command)cc);
            }
        }
    }

    private final class UpdateDetailRunnable
    implements Runnable {
        private final boolean setFocusToDetail;
        private final EObject eObject;

        UpdateDetailRunnable(boolean setFocusToDetail, EObject eObject) {
            this.setFocusToDetail = setFocusToDetail;
            this.eObject = eObject;
        }

        @Override
        public void run() {
            if (TreeMasterDetailComposite.this.detailManager.isDisposed()) {
                return;
            }
            if (TreeMasterDetailComposite.this.viewModelPropertiesUpdateCallback != null) {
                TreeMasterDetailComposite.this.viewModelPropertiesUpdateCallback.updateViewModelProperties(TreeMasterDetailComposite.this.detailManager.getDetailProperties());
            }
            VView view = TreeMasterDetailComposite.this.detailManager.getDetailView(this.eObject);
            ViewModelContext modelContext = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)view, this.eObject, TreeMasterDetailComposite.this.customization.getViewModelServices(view, this.eObject));
            TreeMasterDetailComposite.this.detailManager.setNoDetailMessage(TreeMasterDetailComposite.this.selectNodeMessage);
            if (TreeMasterDetailComposite.this.detailManager.isDisposed()) {
                return;
            }
            TreeMasterDetailComposite.this.detailManager.render(modelContext, (arg_0, arg_1) -> ((ECPSWTViewRenderer)ECPSWTViewRenderer.INSTANCE).render(arg_0, arg_1));
            TreeMasterDetailComposite.this.updateScrolledComposite();
            if (this.setFocusToDetail) {
                TreeMasterDetailComposite.this.setFocusToDetail();
            }
            for (DetailPanelRenderingFinishedCallback callback : TreeMasterDetailComposite.this.detailPanelRenderingFinishedCallbacks) {
                callback.renderingFinished(this.eObject);
            }
        }
    }
}

