/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.spi;

import java.lang.ref.ReferenceQueue;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Pool;
import org.eclipse.emf.common.util.WeakInterningHashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;

public final class Labelizer {
    private static final Pool<Labelizer> POOL = new PoolImpl();
    private final EPackage ePackage;
    private AdapterFactory adapterFactory;

    private Labelizer(EPackage ePackage) {
        this.ePackage = ePackage;
    }

    IDisposable initialize() {
        List<Object> types = Arrays.asList(this.ePackage, IItemLabelProvider.class);
        ComposedAdapterFactory.Descriptor desc = ComposedAdapterFactory.Descriptor.Registry.INSTANCE.getDescriptor(types);
        if (desc != null) {
            this.adapterFactory = desc.createAdapterFactory();
        }
        if (this.adapterFactory == null) {
            this.adapterFactory = new ReflectiveItemProviderAdapterFactory();
        }
        return this.adapterFactory instanceof IDisposable ? (IDisposable)this.adapterFactory : Labelizer::pass;
    }

    private static void pass() {
    }

    public static Labelizer get(EObject object) {
        return Labelizer.get(object.eClass().getEPackage());
    }

    public static Labelizer get(EPackage ePackage) {
        Labelizer result = new Labelizer(ePackage);
        return (Labelizer)POOL.intern((Object)result);
    }

    public String getLabel(EObject object) {
        String result = null;
        IItemLabelProvider labels = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)object, IItemLabelProvider.class);
        if (labels != null) {
            result = labels.getText((Object)object);
        }
        if (result == null) {
            result = String.valueOf(object);
        }
        return result;
    }

    public int hashCode() {
        return this.ePackage.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Labelizer && ((Labelizer)obj).ePackage.equals(this.ePackage);
    }

    private static final class PoolImpl
    extends Pool<Labelizer> {
        PoolImpl() {
            super(8, null, null);
        }

        protected void putEntry(int index, WeakInterningHashSet.Entry<Labelizer> entry) {
            ((EntryImpl)entry).initialize();
            super.putEntry(index, entry);
        }

        protected boolean removeEntry(int index, WeakInterningHashSet.Entry<Labelizer> entry) {
            ((EntryImpl)entry).dispose();
            return super.removeEntry(index, entry);
        }

        protected WeakInterningHashSet.Entry<Labelizer> newExternalEntry(Labelizer object, int hashCode) {
            return new EntryImpl(this, object, hashCode, this.externalQueue);
        }

        private static final class EntryImpl
        extends Pool.PoolEntry<Labelizer> {
            private IDisposable disposer;

            EntryImpl(PoolImpl pool, Labelizer labelizer, int hashCode, ReferenceQueue<Object> externalQueue) {
                super((Pool)pool, (Object)labelizer, hashCode, externalQueue);
            }

            void initialize() {
                this.disposer = ((Labelizer)this.get()).initialize();
            }

            void dispose() {
                if (this.disposer != null) {
                    this.disposer.dispose();
                    this.disposer = null;
                }
            }
        }
    }
}

