/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emf2web.json.generator.xtend;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.emf2web.json.generator.xtend.JsonGenerator;
import org.eclipse.emf.ecp.emf2web.util.ReferenceHelper;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategorization;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategorizationElement;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategory;
import org.eclipse.emf.ecp.view.spi.label.model.VLabel;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VContainer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;

public class FormsJsonGenerator
extends JsonGenerator {
    private static final String TYPE = "type";
    private static final String ELEMENTS = "elements";
    private static final String CONTROL = "Control";
    private static final String CATEGORIZATION = "Categorization";
    private static final String CATEGORY = "Category";
    private static final String SCOPE = "scope";
    private static final String LABEL = "label";
    private ReferenceHelper refHelper;

    public FormsJsonGenerator(ReferenceHelper refHelper) {
        this.refHelper = refHelper;
    }

    @Override
    public JsonElement createJsonElement(EObject object) {
        return this.createJsonFormsElement(object);
    }

    private JsonElement _createJsonFormsElement(VLabel label) {
        JsonObject _xblockexpression = null;
        JsonObject jsonObj = new JsonObject();
        this.withType(jsonObj, "Label");
        _xblockexpression = this.with(jsonObj, "text", label.getName());
        return _xblockexpression;
    }

    private JsonElement _createJsonFormsElement(VCategorizationElement categorizationElement) {
        return this.withElements(this.withType(new JsonObject(), CATEGORIZATION), (Collection<? extends VElement>)categorizationElement.getCategorizations());
    }

    private JsonElement _createJsonFormsElement(VCategorization categorization) {
        return this.withElements(this.withLabel(this.withType(new JsonObject(), CATEGORIZATION), categorization.getLabel()), (Collection<? extends VElement>)categorization.getCategorizations());
    }

    private JsonElement _createJsonFormsElement(VCategory category) {
        JsonObject _xblockexpression = null;
        JsonObject jsonObj = new JsonObject();
        this.withType(jsonObj, CATEGORY);
        this.withLabel(jsonObj, category.getLabel());
        VContainedElement contained = category.getComposite();
        JsonObject _switchResult = null;
        boolean _matched = false;
        if (contained instanceof VContainer) {
            _matched = true;
            _switchResult = this.withElements(jsonObj, (Collection<? extends VElement>)((VContainer)contained).getChildren());
        }
        if (!_matched) {
            throw new UnsupportedOperationException("Category must contain a VContainer element");
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private JsonElement _createJsonFormsElement(VView view) {
        JsonObject _switchResult = null;
        int _size = view.getChildren().size();
        switch (_size) {
            case 0: {
                _switchResult = new JsonObject();
                break;
            }
            case 1: {
                _switchResult = this.createJsonFormsElement(view.getChildren().get(0));
                break;
            }
            default: {
                _switchResult = this.createJsonFormsElement(view.getChildren());
            }
        }
        return _switchResult;
    }

    private JsonElement _createJsonFormsElement(VControl control) {
        JsonObject _xblockexpression = null;
        JsonObject jsonObject = new JsonObject();
        this.withType(jsonObject, CONTROL);
        this.withLabel(jsonObject, this.getDisplayLabel(control));
        _xblockexpression = this.withScope(jsonObject, this.getRef(control));
        return _xblockexpression;
    }

    private JsonElement _createJsonFormsElement(VContainer container) {
        boolean _tripleNotEquals;
        JsonObject _xblockexpression = null;
        JsonObject jsonObject = new JsonObject();
        this.withType(jsonObject, this.getType((VElement)container));
        String _name = container.getName();
        boolean bl = _tripleNotEquals = _name != null;
        if (_tripleNotEquals) {
            this.withLabel(jsonObject, this.getDisplayLabel(container.getLabel()));
        }
        _xblockexpression = this.withElements(jsonObject, (Collection<? extends VElement>)container.getChildren());
        return _xblockexpression;
    }

    private JsonElement _createJsonFormsElement(Collection<? extends VElement> elements) {
        JsonObject _xblockexpression = null;
        JsonObject jsonObject = new JsonObject();
        _xblockexpression = this.withVerticalLayout(jsonObject, elements);
        return _xblockexpression;
    }

    private JsonElement _createJsonFormsElement(EObject object) {
        return new JsonObject();
    }

    private JsonElement _createJsonFormsElement(Void x) {
        return new JsonObject();
    }

    private JsonObject withType(JsonObject jsonObject, String type) {
        return this.with(jsonObject, TYPE, type);
    }

    private JsonObject withScope(JsonObject jsonObject, String ref) {
        return this.with(jsonObject, SCOPE, ref);
    }

    private JsonObject withLabel(JsonObject jsonObject, String label) {
        return this.with(jsonObject, LABEL, label);
    }

    private JsonObject withElements(JsonObject jsonObject, Collection<? extends VElement> elements) {
        return this.with(jsonObject, ELEMENTS, elements);
    }

    private JsonObject withVerticalLayout(JsonObject jsonObject, Collection<? extends VElement> elements) {
        JsonObject _xblockexpression = null;
        this.withType(jsonObject, "VerticalLayout");
        _xblockexpression = this.withElements(jsonObject, elements);
        return _xblockexpression;
    }

    private String getType(VElement vElement) {
        return vElement.eClass().getName();
    }

    private String getRef(VControl control) {
        return this.refHelper.getStringRepresentation(control.getDomainModelReference());
    }

    private String getDisplayLabel(VControl control) {
        return this.refHelper.getLabel(control.getDomainModelReference());
    }

    private String getDisplayLabel(String containerLabel) {
        String _xblockexpression = null;
        boolean _startsWith = containerLabel.trim().startsWith("%");
        if (_startsWith) {
            boolean _greaterThan;
            String label = containerLabel.trim().substring(1);
            String[] split = label.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
            int _length = split[0].length();
            boolean bl = _greaterThan = _length > 0;
            if (_greaterThan) {
                String _string;
                char[] charArray = split[0].toCharArray();
                charArray[0] = Character.toUpperCase(charArray[0]);
                split[0] = _string = new String(charArray);
            }
            StringBuilder sb = new StringBuilder();
            String[] stringArray = split;
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                sb.append(str);
                sb.append(" ");
                ++n2;
            }
            return sb.toString().trim();
        }
        _xblockexpression = containerLabel;
        return _xblockexpression;
    }

    private JsonElement createJsonFormsElement(Object categorization) {
        if (categorization instanceof VCategorization) {
            return this._createJsonFormsElement((VCategorization)categorization);
        }
        if (categorization instanceof VCategory) {
            return this._createJsonFormsElement((VCategory)categorization);
        }
        if (categorization instanceof VCategorizationElement) {
            return this._createJsonFormsElement((VCategorizationElement)categorization);
        }
        if (categorization instanceof VLabel) {
            return this._createJsonFormsElement((VLabel)categorization);
        }
        if (categorization instanceof VControl) {
            return this._createJsonFormsElement((VControl)categorization);
        }
        if (categorization instanceof VContainer) {
            return this._createJsonFormsElement((VContainer)categorization);
        }
        if (categorization instanceof VView) {
            return this._createJsonFormsElement((VView)categorization);
        }
        if (categorization instanceof Collection) {
            return this._createJsonFormsElement((Collection)categorization);
        }
        if (categorization instanceof EObject) {
            return this._createJsonFormsElement((EObject)categorization);
        }
        if (categorization == null) {
            return this._createJsonFormsElement((Void)null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(categorization).toString());
    }
}

