/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.common.RankingHelper;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.segments.DmrToRootEClassConverter;
import org.eclipse.emfforms.spi.core.services.segments.LegacyDmrToRootEClass;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(name="LegacyDmrToRootEClassImpl")
public class LegacyDmrToRootEClassImpl
implements LegacyDmrToRootEClass {
    private static final RankingHelper<DmrToRootEClassConverter> RANKING_HELPER = new RankingHelper(DmrToRootEClassConverter.class, Double.NEGATIVE_INFINITY, Double.valueOf(Double.NEGATIVE_INFINITY));
    private final List<DmrToRootEClassConverter> converters = new LinkedList<DmrToRootEClassConverter>();
    private ReportService reportService;

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    void addDmrToRootEClassConverter(DmrToRootEClassConverter converter) {
        this.converters.add(converter);
    }

    void removeDmrToRootEClassConverter(DmrToRootEClassConverter converter) {
        this.converters.remove(converter);
    }

    @Reference(unbind="-")
    void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Override
    public Optional<EClass> getRootEClass(VDomainModelReference dmr) {
        DmrToRootEClassConverter bestConverter = (DmrToRootEClassConverter)RANKING_HELPER.getHighestRankingElement(this.converters, converter -> converter.isApplicable(dmr));
        if (bestConverter != null) {
            try {
                return Optional.of(bestConverter.getRootEClass(dmr));
            }
            catch (IllegalArgumentException ex) {
                this.reportService.report(new AbstractReport((Throwable)ex, "Could not determine root EClass due to an exception."));
            }
        } else {
            this.reportService.report(new AbstractReport(MessageFormat.format("Could not get root EClass for DMR ''{0}'' because there was no applicable DmrToRootEClassConverter.", dmr), 2));
        }
        return Optional.empty();
    }
}

