/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.internal.tooling.controls;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.ide.spi.util.EcoreHelper;
import org.eclipse.emf.ecp.view.internal.editor.controls.EditableEReferenceLabelControlSWTRenderer;
import org.eclipse.emf.ecp.view.internal.editor.handler.CreateSegmentDmrWizard;
import org.eclipse.emf.ecp.view.internal.editor.handler.FeatureSegmentGenerator;
import org.eclipse.emf.ecp.view.internal.editor.handler.SegmentGenerator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplate;
import org.eclipse.emf.ecp.view.template.selector.domainmodelreference.model.VTDomainModelReferenceSelector;
import org.eclipse.emf.ecp.view.template.selector.domainmodelreference.model.VTDomainmodelreferencePackage;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DmrSelectorSegmentDmrControlSWTRenderer
extends EditableEReferenceLabelControlSWTRenderer {
    private AdapterFactoryItemDelegator adapterFactoryItemDelegator;
    private final EMFFormsDatabindingEMF databindingEMF;
    private ComposedAdapterFactory composedAdapterFactory;

    @Inject
    public DmrSelectorSegmentDmrControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabindingEMF databindingEMF) {
        super(vElement, viewContext, reportService);
        this.databindingEMF = databindingEMF;
    }

    protected Control createSWTControl(Composite parent) throws DatabindingFailedException {
        Control control = super.createSWTControl(parent);
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)this.composedAdapterFactory);
        return control;
    }

    protected void linkValue(Shell shell) {
        IObservableValue observableValue;
        CreateSegmentDmrWizard dmrWizard = new CreateSegmentDmrWizard("Create Selector Domain Model Reference", sf -> null, (SegmentGenerator)new FeatureSegmentGenerator(), null, false);
        WizardDialog wd = new WizardDialog(shell, (IWizard)dmrWizard);
        wd.setBlockOnOpen(true);
        int open = wd.open();
        if (1 == open) {
            return;
        }
        try {
            observableValue = this.getModelValue();
        }
        catch (DatabindingFailedException ex) {
            this.showLinkValueFailedMessageDialog(shell, (Exception)((Object)ex));
            return;
        }
        EObject eObject = (EObject)((IObserving)observableValue).getObserved();
        VDomainModelReference dmr = (VDomainModelReference)dmrWizard.getDomainModelReference().get();
        EClass rootEClass = (EClass)dmrWizard.getRootEClass().get();
        Optional selectedEcore = dmrWizard.getSelectedEcore();
        if (selectedEcore.isPresent()) {
            String ecorePath = ((IFile)selectedEcore.get()).getFullPath().toString();
            try {
                EcoreHelper.registerEcore((String)ecorePath);
                this.addEcorePathToTemplate(ecorePath);
                String nsUri = rootEClass.getEPackage().getNsURI();
                EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsUri);
                rootEClass = (EClass)ePackage.getEClassifier(rootEClass.getName());
            }
            catch (IOException ex) {
                this.getReportService().report(new AbstractReport((Throwable)ex, String.format("Could not add ecore path \"%s\" to the view template.", ecorePath)));
            }
        }
        this.setDmrAndRootEClass(eObject, dmr, rootEClass);
    }

    void setDmrAndRootEClass(EObject eObject, VDomainModelReference dmr, EClass rootEClass) {
        LinkedList<Command> commands = new LinkedList<Command>();
        EditingDomain editingDomain = this.getEditingDomain(eObject);
        EReference rootEClassFeature = VTDomainmodelreferencePackage.Literals.DOMAIN_MODEL_REFERENCE_SELECTOR__ROOT_ECLASS;
        if (eObject.eClass().getEAllReferences().contains((Object)rootEClassFeature)) {
            commands.add(SetCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)rootEClassFeature, (Object)rootEClass));
        }
        EReference dmrFeature = VTDomainmodelreferencePackage.Literals.DOMAIN_MODEL_REFERENCE_SELECTOR__DOMAIN_MODEL_REFERENCE;
        commands.add(SetCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)dmrFeature, (Object)dmr));
        CompoundCommand compoundCommand = new CompoundCommand(commands);
        editingDomain.getCommandStack().execute((Command)compoundCommand);
    }

    private void addEcorePathToTemplate(String ecorePath) {
        EObject domain = this.getViewModelContext().getDomainModel();
        while (!VTViewTemplate.class.isInstance(domain)) {
            domain = domain.eContainer();
        }
        if (!VTViewTemplate.class.isInstance(domain)) {
            return;
        }
        ((VTViewTemplate)VTViewTemplate.class.cast(domain)).getReferencedEcores().add((Object)ecorePath);
    }

    protected Object getText(Object value) {
        VDomainModelReference modelReference = (VDomainModelReference)value;
        if (modelReference == null || modelReference.getSegments().isEmpty()) {
            return null;
        }
        VTDomainModelReferenceSelector selector = (VTDomainModelReferenceSelector)VTDomainModelReferenceSelector.class.cast(this.getViewModelContext().getDomainModel());
        EClass rootEClass = selector.getRootEClass();
        EList segments = modelReference.getSegments();
        String attributeType = null;
        try {
            IEMFValueProperty valueProperty = this.databindingEMF.getValueProperty(modelReference, rootEClass);
            attributeType = valueProperty.getStructuralFeature().getEType().getName();
        }
        catch (DatabindingFailedException valueProperty) {
            // empty catch block
        }
        String attributeName = " -> " + this.adapterFactoryItemDelegator.getText(segments.get(segments.size() - 1));
        if (attributeType != null && !attributeType.isEmpty()) {
            attributeName = String.valueOf(attributeName) + " : " + attributeType;
        }
        String referencePath = "";
        int i = 0;
        while (i < segments.size() - 1) {
            referencePath = String.valueOf(referencePath) + " -> " + this.adapterFactoryItemDelegator.getText(segments.get(i));
            ++i;
        }
        String linkText = String.valueOf(rootEClass.getName()) + referencePath + attributeName;
        if (linkText.equals(" -> ")) {
            return null;
        }
        return linkText;
    }

    public void dispose() {
        super.dispose();
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
    }
}

