/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.common.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emfforms.spi.common.converter.EStructuralFeatureValueConverter;
import org.osgi.service.component.annotations.Component;

@Component
public class DefaultEAttributeValueConverterImpl
implements EStructuralFeatureValueConverter {
    public static final String DEFAULT_LIST_SEPARATOR = ",";
    public static final double DEFAULT_PRIORITY = 2.0;
    private final String listSeparator;
    private final double priority;

    public DefaultEAttributeValueConverterImpl() {
        this(DEFAULT_LIST_SEPARATOR, 2.0);
    }

    protected DefaultEAttributeValueConverterImpl(String listSeparator, double priority) {
        this.listSeparator = listSeparator;
        this.priority = priority;
    }

    @Override
    public double isApplicable(EObject eObject, EStructuralFeature feature, Object value, EStructuralFeatureValueConverter.Direction direction) {
        if (EStructuralFeatureValueConverter.Direction.MODEL_TO_LITERAL.equals((Object)direction) || feature instanceof EReference) {
            return -1.0;
        }
        return this.priority;
    }

    @Override
    public Object convertToModelValue(EObject eObject, EStructuralFeature feature, String literal) {
        try {
            if (feature.isMany()) {
                ArrayList<Object> objects = new ArrayList<Object>();
                StringTokenizer tokenizer = new StringTokenizer(literal, this.listSeparator, false);
                while (tokenizer.hasMoreTokens()) {
                    String item = tokenizer.nextToken();
                    objects.add(this.fromString(feature, item.trim()));
                }
                return objects;
            }
            return this.fromString(feature, literal);
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    @Override
    public Object convertToLiteral(EObject eObject, EStructuralFeature feature, Object instance) {
        try {
            if (instance instanceof Collection) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Object object : (Collection)instance) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.listSeparator);
                    }
                    stringBuilder.append(String.valueOf(this.toString(feature, object)));
                }
                return stringBuilder.toString();
            }
            return this.toString(feature, instance);
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    protected Object fromString(EStructuralFeature feature, String literal) {
        return EcoreUtil.createFromString((EDataType)((EAttribute)feature).getEAttributeType(), (String)literal);
    }

    protected Object toString(EStructuralFeature feature, Object instance) {
        return String.valueOf(instance);
    }
}

