/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.spi.util;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecp.ide.internal.Activator;
import org.eclipse.emf.ecp.ide.spi.util.EcoreHelper;
import org.eclipse.emf.ecp.internal.ide.util.messages.Messages;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;

public final class ViewModelHelper {
    private ViewModelHelper() {
    }

    public static VView createViewModel(IFile modelFile, EClass selectedEClass, IFile selectedEcore) throws IOException {
        EPackage ep;
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{adapterFactory, new ReflectiveItemProviderAdapterFactory()});
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)new BasicCommandStack());
        URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
        Resource resource = domain.createResource(fileURI.toString());
        VView view = VViewPackage.eINSTANCE.getViewFactory().createView();
        if (view == null) {
            return null;
        }
        resource.getContents().add((Object)view);
        EPackage ePackage = selectedEClass.getEPackage();
        EPackage.Registry instance = EPackage.Registry.INSTANCE;
        Object ePackageObject = instance.get((Object)ePackage.getNsURI());
        if (EPackage.Descriptor.class.isInstance(ePackageObject)) {
            EPackage.Descriptor descriptor = (EPackage.Descriptor)EPackage.Descriptor.class.cast(ePackageObject);
            ep = descriptor.getEPackage();
        } else {
            ep = EPackage.class.isInstance(ePackageObject) ? (EPackage)ePackageObject : null;
        }
        if (ep == null && selectedEcore != null) {
            EcoreHelper.registerEcore(selectedEcore.getFullPath().toString());
            ep = (EPackage)instance.get((Object)ePackage.getNsURI());
        }
        EClass ec = (EClass)ep.getEClassifier(selectedEClass.getName());
        view.setRootEClass(ec);
        view.setName(selectedEClass.getName());
        if (selectedEcore != null && !view.getEcorePaths().contains((Object)selectedEcore.getFullPath().toString())) {
            view.getEcorePaths().add((Object)selectedEcore.getFullPath().toString());
        }
        resource.save(Collections.singletonMap("ENCODING", "UTF-8"));
        return view;
    }

    public static VView loadView(IFile file, Collection<String> registeredEcores) throws IOException {
        return new ViewLoader().loadView(file, registeredEcores);
    }

    public static boolean viewIsResolved(VView view) {
        return !view.getRootEClass().eIsProxy();
    }

    public static List<String> getEcorePaths(Resource resource) {
        if (resource == null || resource.getContents().isEmpty()) {
            return Collections.emptyList();
        }
        EObject eObject = (EObject)resource.getContents().get(0);
        if (VView.class.isInstance(eObject)) {
            return ((VView)VView.class.cast(eObject)).getEcorePaths();
        }
        if (AnyType.class.isInstance(eObject)) {
            FeatureMap anyAttribute = ((AnyType)AnyType.class.cast(eObject)).getAnyAttribute();
            int i = 0;
            while (i < anyAttribute.size()) {
                EStructuralFeature feature = anyAttribute.getEStructuralFeature(i);
                if ("ecorePath".equals(feature.getName())) {
                    return Arrays.asList((String)anyAttribute.getValue(i));
                }
                ++i;
            }
            FeatureMap any = ((AnyType)AnyType.class.cast(eObject)).getAny();
            LinkedList<String> ecorePaths = new LinkedList<String>();
            int i2 = 0;
            while (i2 < any.size()) {
                AnyType listType;
                FeatureMap mixed;
                FeatureMap.ValueListIterator iterator;
                EStructuralFeature feature = any.getEStructuralFeature(i2);
                if ("ecorePaths".equals(feature.getName()) && (iterator = (mixed = (listType = (AnyType)any.getValue(i2)).getMixed()).valueListIterator()).hasNext()) {
                    ecorePaths.add((String)iterator.next());
                }
                ++i2;
            }
            return ecorePaths;
        }
        return Collections.emptyList();
    }

    public static class ViewLoader {
        public VView loadView(IFile file, Collection<String> registeredEcores) throws IOException {
            String path = this.getPath(file);
            VView view = this.loadView(path);
            this.registerReferencedEcores(view, path, registeredEcores);
            if (view != null && !ViewModelHelper.viewIsResolved(view)) {
                EcoreUtil.resolveAll((EObject)view);
            }
            return view;
        }

        protected String getPath(IFile file) {
            return file.getLocation().toString();
        }

        protected VView loadView(String path) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI fileURI = URI.createFileURI((String)path);
            Resource resource = resourceSet.getResource(fileURI, true);
            if (resource != null) {
                return (VView)resource.getContents().get(0);
            }
            return null;
        }

        protected void registerReferencedEcores(VView view, String viewLocation, Collection<String> registeredEcores) throws IOException {
            if (view == null || view.getEcorePaths() == null) {
                return;
            }
            for (String ecorePath : view.getEcorePaths()) {
                if (!this.ecoreExistsInWorkspace(ecorePath)) {
                    String message = MessageFormat.format(Messages.ViewModelHelper_couldNotFindEcorePath_message, ecorePath, this.getViewNameAndLocation(view, viewLocation));
                    this.getReportService().report(new AbstractReport(message, 2));
                    continue;
                }
                this.registerEcore(ecorePath);
                registeredEcores.add(ecorePath);
            }
        }

        protected String getViewNameAndLocation(VView view, String viewLocation) {
            return this.getViewName(view).map(viewName -> MessageFormat.format(Messages.ViewModelHelper_couldNotFindEcorePath_nameAndLocation, viewName, viewLocation)).orElse(viewLocation);
        }

        protected Optional<String> getViewName(VView view) {
            if (view.getLabel() != null && !view.getLabel().isEmpty()) {
                return Optional.of(view.getLabel());
            }
            if (view.getName() != null && !view.getName().isEmpty()) {
                return Optional.of(view.getName());
            }
            if (view.getRootEClass() != null && view.getRootEClass().getName() != null) {
                return Optional.of(view.getRootEClass().getName());
            }
            return Optional.empty();
        }

        protected boolean ecoreExistsInWorkspace(String ecorePath) {
            return ResourcesPlugin.getWorkspace().getRoot().findMember(ecorePath) != null;
        }

        protected ReportService getReportService() {
            return Activator.getDefault().getReportService();
        }

        protected void registerEcore(String ecorePath) throws IOException {
            EcoreHelper.registerEcore(ecorePath);
        }
    }
}

