/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.internal.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class MetamodelUtils {
    static final String GENERIC = "Generic";

    private MetamodelUtils() {
    }

    public static boolean isGenericReference(EReference reference) {
        return reference.getEReferenceType() == EcorePackage.eINSTANCE.getEGenericType();
    }

    public static EReference getNonGenericReference(EReference genericReference) {
        EClass c = genericReference.getEContainingClass();
        String referenceName = genericReference.getName().replace(GENERIC, "");
        EReference nonGenericReference = (EReference)c.getEStructuralFeature(referenceName);
        return nonGenericReference;
    }

    public static EReference getGenericReference(EReference reference) {
        String name = reference.getName();
        name = String.valueOf(name.charAt(0)) + GENERIC + name.substring(1);
        return (EReference)reference.getEContainingClass().getEStructuralFeature(name);
    }

    public static <V extends EModelElement> V copy(V modelElement) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier(){

            protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
                Object value;
                if (eReference == EcorePackage.eINSTANCE.getEReference_EOpposite() && eObject.eIsSet((EStructuralFeature)eReference) && this.get(value = eObject.eGet((EStructuralFeature)eReference)) == null) {
                    return;
                }
                super.copyReference(eReference, eObject, copyEObject);
            }
        };
        EModelElement result = (EModelElement)copier.copy(modelElement);
        copier.copyReferences();
        return (V)result;
    }

    public static Collection<EPackage> getAllRootPackages(ResourceSet resourceSet) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        for (Resource resource : resourceSet.getResources()) {
            if (!MetamodelUtils.isMetamodelResource(resource)) continue;
            for (EObject o : resource.getContents()) {
                if (!(o instanceof EPackage)) continue;
                EPackage p = (EPackage)o;
                result.add(p);
            }
        }
        return result;
    }

    public static boolean isMetamodelResource(Resource resource) {
        URI uri = resource.getURI();
        return MetamodelUtils.isMetamodelURI(uri);
    }

    public static boolean isMetamodelURI(URI uri) {
        return "ecore".equals(uri.fileExtension());
    }

    public static EPackage getRootPackage(ResourceSet resourceSet) {
        Resource resource = (Resource)resourceSet.getResources().get(0);
        return (EPackage)resource.getContents().get(0);
    }

    public static boolean isConcrete(EClass eClass) {
        return !eClass.isAbstract() && !eClass.isInterface();
    }

    public static List<EClass> subtractTypes(EClass minuend, EClass subtrahend) {
        ArrayList<EClass> superTypes = new ArrayList<EClass>();
        superTypes.addAll((Collection<EClass>)minuend.getEAllSuperTypes());
        superTypes.add(0, minuend);
        superTypes.removeAll((Collection<?>)subtrahend.getEAllSuperTypes());
        superTypes.remove(subtrahend);
        return superTypes;
    }

    public static List<EStructuralFeature> subtractFeatures(EClass minuend, EClass subtrahend) {
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        List<EClass> superTypes = MetamodelUtils.subtractTypes(minuend, subtrahend);
        for (EClass superType : superTypes) {
            features.addAll((Collection<EStructuralFeature>)superType.getEStructuralFeatures());
        }
        return features;
    }

    public static ResourceSet createIndependentMetamodelCopy(Collection<EPackage> rootPackages, URI metamodelURI) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(metamodelURI);
        EcoreUtil.Copier copier = new EcoreUtil.Copier((ResourceSet)resourceSet){
            private final /* synthetic */ ResourceSet val$resourceSet;
            {
                this.val$resourceSet = resourceSet;
            }

            protected void copyReference(EReference reference, EObject object, EObject copyEObject) {
                if (MetamodelUtils.getGenericReference(reference) != null) {
                    object.eGet((EStructuralFeature)reference);
                }
                super.copyReference(reference, object, copyEObject);
            }

            public EObject get(Object key) {
                EObject element;
                EObject value = (EObject)super.get(key);
                if (value == null && key instanceof EObject && (element = (EObject)key).eResource() != null) {
                    URI uri = EcoreUtil.getURI((EObject)element);
                    EObject loaded = this.val$resourceSet.getEObject(uri, true);
                    return loaded;
                }
                return value;
            }
        };
        Collection copy = copier.copyAll(rootPackages);
        resource.getContents().addAll(copy);
        copier.copyReferences();
        return resourceSet;
    }
}

