/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecp.view.model.common.AbstractRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.layout.EMFFormsSWTLayoutUtil;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractSWTRenderer<VELEMENT extends VElement>
extends AbstractRenderer<VELEMENT> {
    protected static final String CUSTOM_VARIANT = "org.eclipse.rap.rwt.customVariant";
    private ModelChangeListener listener;
    private Map<SWTGridCell, Control> controls;
    private boolean renderingFinished;

    public AbstractSWTRenderer(VELEMENT vElement, ViewModelContext viewContext, ReportService reportService) {
        super(vElement, viewContext, reportService);
    }

    public abstract SWTGridDescription getGridDescription(SWTGridDescription var1);

    public final void init() {
        this.preInit();
        this.controls = new LinkedHashMap<SWTGridCell, Control>();
        if (this.getViewModelContext() != null) {
            this.listener = new ViewChangeListener();
            this.getViewModelContext().registerViewChangeListener(this.listener);
        }
        this.getViewModelContext().addContextUser((Object)this);
        this.postInit();
    }

    protected final Map<SWTGridCell, Control> getControls() {
        if (this.controls == null) {
            return Collections.emptyMap();
        }
        return new LinkedHashMap<SWTGridCell, Control>(this.controls);
    }

    protected void preInit() {
    }

    protected void postInit() {
    }

    protected void dispose() {
        if (this.getViewModelContext() != null) {
            this.getViewModelContext().unregisterViewChangeListener(this.listener);
        }
        this.listener = null;
        this.controls = null;
        this.getViewModelContext().removeContextUser((Object)this);
        super.dispose();
    }

    public Control render(final SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Control control = this.controls.get((Object)cell);
        if (control != null) {
            return control;
        }
        control = this.renderControl(cell, parent);
        if (control == null) {
            return null;
        }
        this.controls.put(cell, control);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractSWTRenderer.this.controls != null) {
                    AbstractSWTRenderer.this.controls.remove((Object)cell);
                }
            }
        });
        return control;
    }

    public void finalizeRendering(Composite parent) {
        if (this.renderingFinished) {
            return;
        }
        this.renderingFinished = true;
        if (!this.getVElement().isVisible()) {
            this.applyVisible();
        }
        this.applyReadOnly();
        if (!this.ignoreEnableOnReadOnly()) {
            this.applyEnable();
        }
        this.applyValidation();
        if (!this.controls.isEmpty()) {
            this.controls.values().iterator().next().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AbstractSWTRenderer.this.dispose();
                }
            });
        }
    }

    protected boolean isRenderingFinished() {
        return this.renderingFinished;
    }

    protected boolean ignoreEnableOnReadOnly() {
        return this.getVElement().isEffectivelyReadonly();
    }

    protected abstract Control renderControl(SWTGridCell var1, Composite var2) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption;

    protected void applyReadOnly() {
    }

    protected void applyEnable() {
    }

    protected void setControlEnabled(SWTGridCell gridCell, Control control, boolean enabled) {
        control.setEnabled(enabled);
    }

    protected void applyVisible() {
        boolean visible = this.getVElement().isVisible();
        LinkedHashSet<Composite> parents = new LinkedHashSet<Composite>();
        for (SWTGridCell gridCell : this.controls.keySet()) {
            GridData gridData;
            Object layoutData = this.controls.get((Object)gridCell).getLayoutData();
            if (GridData.class.isInstance(layoutData) && (gridData = (GridData)layoutData) != null) {
                gridData.exclude = !visible;
            }
            this.controls.get((Object)gridCell).setVisible(visible);
            parents.add(this.controls.get((Object)gridCell).getParent());
        }
        for (Composite composite : parents) {
            EMFFormsSWTLayoutUtil.adjustParentSize(composite.getChildren()[0]);
        }
    }

    protected void applyValidation() {
    }

    protected void applyValidation(VDiagnostic oldDiagnostic, VDiagnostic newDiagnostic) {
    }

    protected String getDefaultFontName(Control control) {
        return control.getDisplay().getSystemFont().getFontData()[0].getName();
    }

    public void scrollToReveal() {
        if (this.controls != null && !this.controls.isEmpty()) {
            AbstractTreeIterator<Control> iter = new AbstractTreeIterator<Control>(this.controls.values(), false){

                protected Iterator<? extends Control> getChildren(Object object) {
                    if (object instanceof Composite) {
                        return Arrays.asList(((Composite)object).getChildren()).iterator();
                    }
                    if (object instanceof Collection) {
                        Collection collection = (Collection)object;
                        return collection.iterator();
                    }
                    return Collections.emptyIterator();
                }
            };
            while (iter.hasNext()) {
                Control next = (Control)iter.next();
                if (!(next instanceof Composite) && this.scrollToReveal(next)) break;
            }
        }
    }

    protected boolean scrollToReveal(Control control) {
        Composite parent = control.getParent();
        while (parent != null) {
            if (parent instanceof ScrolledComposite) {
                ScrolledComposite scrolled = (ScrolledComposite)parent;
                scrolled.showControl(control);
            }
            parent = parent.getParent();
        }
        return control.setFocus();
    }

    protected boolean canReveal(Control control) {
        return control != null && !control.isDisposed() && control.isVisible();
    }

    private final class ViewChangeListener
    implements ModelChangeListener {
        private ViewChangeListener() {
        }

        public void notifyChange(ModelChangeNotification notification) {
            if (!AbstractSWTRenderer.this.renderingFinished) {
                return;
            }
            if (notification.getRawNotification().isTouch() && notification.getStructuralFeature() != VViewPackage.Literals.ELEMENT__DIAGNOSTIC) {
                return;
            }
            if (notification.getStructuralFeature() == VViewPackage.Literals.ELEMENT__ENABLED) {
                if (!AbstractSWTRenderer.this.ignoreEnableOnReadOnly()) {
                    AbstractSWTRenderer.this.applyEnable();
                }
            } else if (notification.getStructuralFeature() == VViewPackage.Literals.ELEMENT__READONLY) {
                AbstractSWTRenderer.this.applyReadOnly();
            }
            if (notification.getNotifier() != AbstractSWTRenderer.this.getVElement()) {
                return;
            }
            if (notification.getStructuralFeature() == VViewPackage.Literals.ELEMENT__VISIBLE) {
                AbstractSWTRenderer.this.applyVisible();
            } else if (notification.getStructuralFeature() == VViewPackage.Literals.ELEMENT__DIAGNOSTIC) {
                VDiagnostic newDia = (VDiagnostic)notification.getRawNotification().getNewValue();
                VDiagnostic oldDia = (VDiagnostic)notification.getRawNotification().getOldValue();
                AbstractSWTRenderer.this.applyValidation(oldDia, newDia);
                AbstractSWTRenderer.this.applyValidation();
            }
        }
    }
}

