/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.util.swt.rap;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.rap.rwt.service.UISessionEvent;
import org.eclipse.rap.rwt.service.UISessionListener;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;

@Component(service={ImageRegistryService.class}, property={"service.ranking:Integer=5"})
public class RAPImageRegistryService
implements ImageRegistryService,
UISessionListener {
    private static final long serialVersionUID = 1223772305074418261L;
    private final Map<String, Map<String, WeakReference<Image>>> sessionRegistry = new LinkedHashMap<String, Map<String, WeakReference<Image>>>();

    public void beforeDestroy(UISessionEvent event) {
        this.sessionRegistry.remove(event.getUISession().getId());
    }

    public Image getImage(Bundle bundle, String path) {
        URL url = bundle.getResource(path);
        if (url == null) {
            return null;
        }
        return this.getImage(url);
    }

    public Image getImage(URL url) {
        Map<String, WeakReference<Image>> registry;
        WeakReference<Image> weakRef;
        UISession uiSession = RWT.getUISession();
        uiSession.addUISessionListener((UISessionListener)this);
        String sessionId = uiSession.getId();
        if (!this.sessionRegistry.containsKey(sessionId)) {
            this.sessionRegistry.put(sessionId, new LinkedHashMap());
        }
        boolean loadImage = (weakRef = (registry = this.sessionRegistry.get(sessionId)).get(url.toString())) == null;
        Image image = null;
        if (weakRef != null) {
            image = (Image)weakRef.get();
            boolean bl = loadImage = image == null;
        }
        if (loadImage) {
            image = ImageDescriptor.createFromURL((URL)url).createImage();
            registry.put(url.toString(), new WeakReference<Image>(image));
        }
        return image;
    }
}

