/*******************************************************************************
 * Copyright (c) 2011-2015 EclipseSource Muenchen GmbH and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * Eugen Neufeld - initial API and implementation
 ******************************************************************************/
package org.eclipse.emf.ecp.view.label.rap;

import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.label.model.VLabel;
import org.eclipse.emf.ecp.view.spi.label.model.VLabelPackage;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.di.EMFFormsDIRendererService;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.FrameworkUtil;

/**
 * GroupSWTRendererService which provides the GroupSWTRenderer.
 *
 * @author Eugen Neufeld
 *
 */
public class LabelRAPRendererService implements EMFFormsDIRendererService<VLabel> {

	/**
	 * {@inheritDoc}
	 *
	 * @see org.eclipse.emfforms.spi.swt.core.di.EMFFormsDIRendererService#isApplicable(VElement,ViewModelContext)
	 */
	@Override
	public double isApplicable(VElement vElement, ViewModelContext viewModelContext) {
		if (!VLabelPackage.eINSTANCE.getLabel().isInstance(vElement)) {
			return NOT_APPLICABLE;
		}
		if (!FrameworkUtil.getBundle(Display.class).getSymbolicName()
			.contains(".rwt")) { //$NON-NLS-1$
			return NOT_APPLICABLE;
		}

		return 3;
	}

	/**
	 * {@inheritDoc}
	 *
	 * @see org.eclipse.emfforms.spi.swt.core.di.EMFFormsDIRendererService#getRendererClass()
	 */
	@Override
	public Class<? extends AbstractSWTRenderer<VLabel>> getRendererClass() {
		return LabelRapRenderer.class;
	}

}
