/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.style.alignment.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AlignmentType implements Enumerator
{
    LEFT(0, "LEFT", "LEFT"),
    RIGHT(1, "RIGHT", "RIGHT");

    public static final int LEFT_VALUE = 0;
    public static final int RIGHT_VALUE = 1;
    private static final AlignmentType[] VALUES_ARRAY;
    public static final List<AlignmentType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AlignmentType[]{LEFT, RIGHT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AlignmentType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AlignmentType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AlignmentType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AlignmentType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AlignmentType get(int value) {
        switch (value) {
            case 0: {
                return LEFT;
            }
            case 1: {
                return RIGHT;
            }
        }
        return null;
    }

    private AlignmentType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

