/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.core.services.reveal;

import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.core.services.reveal.FailedStep;
import org.eclipse.emfforms.spi.core.services.reveal.IntermediateStep;
import org.eclipse.emfforms.spi.core.services.reveal.RevealStepKind;
import org.eclipse.emfforms.spi.core.services.reveal.TerminalStep;

public interface RevealStep {
    public static final RevealStep FAILED = new FailedStep();

    public RevealStepKind getType();

    default public boolean isFailed() {
        return this.getType() == RevealStepKind.FAILED;
    }

    default public boolean isDone() {
        return this.getType() != RevealStepKind.INTERMEDIATE;
    }

    public VElement getViewModel();

    public EObject getDomainModel();

    public EStructuralFeature getFeature();

    public RevealStep drillDown();

    public void reveal();

    default public void ifPresent(Consumer<? super RevealStep> action) {
        if (!this.isFailed()) {
            action.accept(this);
        }
    }

    public static RevealStep drillDown(VElement viewModel, EObject domainModel, RevealStep nextStep) {
        return RevealStep.drillDown(viewModel, domainModel, nextStep, null);
    }

    public static RevealStep drillDown(VElement viewModel, EObject domainModel, RevealStep nextStep, Runnable revealAction) {
        return nextStep.isFailed() ? nextStep : new IntermediateStep(viewModel, domainModel, nextStep, revealAction);
    }

    public static RevealStep reveal(VElement viewModel, EObject domainModel, Runnable revealAction) {
        return RevealStep.reveal(viewModel, domainModel, null, revealAction);
    }

    public static RevealStep reveal(VElement viewModel, EObject domainModel, EStructuralFeature feature, Runnable revealAction) {
        return new TerminalStep(viewModel, domainModel, feature, revealAction);
    }

    public static RevealStep fail() {
        return FAILED;
    }

    public static Predicate<RevealStep> is(RevealStepKind type) {
        return step -> step.getType() == type;
    }

    public static Comparator<RevealStep> preferredOrdering() {
        return Comparator.comparing(RevealStep::getType);
    }
}

