/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.internal.tooling.controls;

import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.internal.tooling.Activator;
import org.eclipse.emf.ecp.view.template.internal.tooling.Messages;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class URLSelectionControlSWTRenderer
extends SimpleControlSWTControlSWTRenderer {
    private static final EMFFormsDatabinding EMFFORMS_DATABINDING;
    private static final EMFFormsLabelProvider EMFFORMS_LABELPROVIDER;
    private static final VTViewTemplateProvider VT_VIEW_TEMPLATEPROVIDER;

    static {
        BundleContext bundleContext = FrameworkUtil.getBundle(URLSelectionControlSWTRenderer.class).getBundleContext();
        ServiceReference emfFormsDatabindingServiceReference = bundleContext.getServiceReference(EMFFormsDatabinding.class);
        EMFFORMS_DATABINDING = (EMFFormsDatabinding)bundleContext.getService(emfFormsDatabindingServiceReference);
        ServiceReference emfFormsLabelProviderServiceReference = bundleContext.getServiceReference(EMFFormsLabelProvider.class);
        EMFFORMS_LABELPROVIDER = (EMFFormsLabelProvider)bundleContext.getService(emfFormsLabelProviderServiceReference);
        ServiceReference vtViewTemplateProviderServiceReference = bundleContext.getServiceReference(VTViewTemplateProvider.class);
        VT_VIEW_TEMPLATEPROVIDER = (VTViewTemplateProvider)bundleContext.getService(vtViewTemplateProviderServiceReference);
    }

    public URLSelectionControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService) {
        super(vElement, viewContext, reportService, EMFFORMS_DATABINDING, EMFFORMS_LABELPROVIDER, VT_VIEW_TEMPLATEPROVIDER);
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        Composite composite = (Composite)Composite.class.cast(control);
        Control childControl = composite.getChildren()[0];
        ISWTObservableValue value = WidgetProperties.text().observe((Widget)childControl);
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(), this.withPreSetValidation(new UpdateValueStrategy()), null);
        ISWTObservableValue toolTip = WidgetProperties.tooltipText().observe((Widget)childControl);
        Binding tooltipBinding = this.getDataBindingContext().bindValue((IObservableValue)toolTip, this.getModelValue(), this.withPreSetValidation(new UpdateValueStrategy()), null);
        return new Binding[]{binding, tooltipBinding};
    }

    protected Control createSWTControl(Composite parent) {
        final Composite composite = new Composite(parent, 0);
        composite.setBackgroundMode(2);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(composite);
        Label label = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)label);
        Button selectExternFileButton = new Button(composite, 8);
        GridDataFactory.fillDefaults().align(1, 1).grab(false, false).applyTo((Control)selectExternFileButton);
        selectExternFileButton.setText(Messages.URLSelectionControlSWTRenderer_SelectExternalFileBtn);
        selectExternFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                FileDialog fd = new FileDialog(composite.getShell(), 4096);
                String open = fd.open();
                if (open == null) {
                    return;
                }
                String selectedURL = null;
                try {
                    selectedURL = new File(open).toURI().toURL().toExternalForm();
                }
                catch (MalformedURLException ex) {
                    Activator.log(ex);
                }
                URLSelectionControlSWTRenderer.this.setValue(selectedURL);
            }
        });
        Button selectWorkspaceFileButton = new Button(composite, 8);
        GridDataFactory.fillDefaults().align(1, 1).grab(false, false).applyTo((Control)selectWorkspaceFileButton);
        selectWorkspaceFileButton.setText(Messages.URLSelectionControlSWTRenderer_SelectWorkspaceFileBtn);
        selectWorkspaceFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
                WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
                ElementTreeSelectionDialog etsd = new ElementTreeSelectionDialog(composite.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
                etsd.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                int open = etsd.open();
                if (1 == open) {
                    return;
                }
                IResource resource = (IResource)etsd.getResult()[0];
                String selectedURL = "platform:/plugin" + resource.getFullPath().toString();
                URLSelectionControlSWTRenderer.this.setValue(selectedURL);
            }
        });
        return composite;
    }

    private void setValue(String selectedURL) {
        IObservableValue observableValue;
        try {
            observableValue = this.getEMFFormsDatabinding().getObservableValue(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return;
        }
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        EObject eObject = (EObject)((IObserving)observableValue).getObserved();
        observableValue.dispose();
        EditingDomain editingDomain = this.getEditingDomain(eObject);
        Command command = SetCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)structuralFeature, (Object)selectedURL);
        editingDomain.getCommandStack().execute(command);
    }

    protected String getUnsetText() {
        return Messages.URLSelectionControlSWTRenderer_UnsetText;
    }
}

