/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.tooling.editor;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecp.ide.spi.util.EcoreHelper;
import org.eclipse.emf.ecp.spi.view.migrator.TemplateModelMigrationException;
import org.eclipse.emf.ecp.spi.view.migrator.TemplateModelMigratorUtil;
import org.eclipse.emf.ecp.spi.view.migrator.TemplateModelWorkspaceMigrator;
import org.eclipse.emf.ecp.spi.view.migrator.ViewNsMigrationUtil;
import org.eclipse.emf.ecp.view.template.internal.tooling.Activator;
import org.eclipse.emf.ecp.view.template.internal.tooling.Messages;
import org.eclipse.emf.ecp.view.template.internal.tooling.util.MigrationDialogHelper;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplate;
import org.eclipse.emfforms.spi.editor.GenericEditor;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailComposite;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.CreateElementCallback;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.RootObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.part.FileEditorInput;

public class TemplateModelEditorPart
extends GenericEditor {
    private VTViewTemplate template;
    private TreeMasterDetailComposite treeMasterDetail;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        block6: {
            super.init(site, input);
            super.setPartName(input.getName());
            if (!(input instanceof FileEditorInput)) {
                throw new PartInitException(Messages.TemplateModelEditorPart_invalidEditorInput);
            }
            FileEditorInput fei = (FileEditorInput)this.getEditorInput();
            try {
                boolean migrate;
                if (!ViewNsMigrationUtil.checkMigration((File)fei.getPath().toFile()) && (migrate = MessageDialog.openQuestion((Shell)site.getShell(), (String)Messages.TemplateModelEditorPart_MigrationQuestion, (String)Messages.TemplateModelEditorPart_MigrationDescription))) {
                    ViewNsMigrationUtil.migrateViewEcoreNsUri((File)fei.getPath().toFile());
                    this.migrateWorkspaceModels(site.getShell());
                }
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = resourceSet.createResource(URI.createURI((String)fei.getURI().toURL().toExternalForm()));
                resource.load(null);
                EList resourceContents = resource.getContents();
                if (resourceContents.size() > 0 && VTViewTemplate.class.isInstance(resourceContents.get(0))) {
                    VTViewTemplate template = (VTViewTemplate)resourceContents.get(0);
                    for (String ecorePath : template.getReferencedEcores()) {
                        EcoreHelper.registerEcore((String)ecorePath);
                    }
                    break block6;
                }
                throw new PartInitException(Messages.TemplateModelEditorPart_initError);
            }
            catch (IOException e) {
                Activator.log(e);
                throw new PartInitException(Messages.TemplateModelEditorPart_initError, (Throwable)e);
            }
        }
    }

    protected Object modifyEditorInput(ResourceSet resourceSet) {
        this.template = (VTViewTemplate)VTViewTemplate.class.cast(((Resource)resourceSet.getResources().get(0)).getContents().get(0));
        return new RootObject((EObject)this.template);
    }

    protected TreeMasterDetailComposite createTreeMasterDetail(Composite composite, Object editorInput, CreateElementCallback createElementCallback) {
        this.treeMasterDetail = super.createTreeMasterDetail(composite, editorInput, createElementCallback);
        return this.treeMasterDetail;
    }

    public void dispose() {
        if (this.template != null) {
            for (String ecorePath : this.template.getReferencedEcores()) {
                EcoreHelper.unregisterEcore((String)ecorePath);
            }
        }
        super.dispose();
    }

    public VTViewTemplate getTemplate() {
        return this.template;
    }

    public void reveal(EObject objectToReveal) {
        this.treeMasterDetail.getSelectionProvider().refresh();
        this.treeMasterDetail.getSelectionProvider().reveal((Object)objectToReveal);
        this.treeMasterDetail.setSelection((ISelection)new StructuredSelection((Object)objectToReveal));
    }

    private void migrateWorkspaceModels(Shell shell) {
        final TemplateModelWorkspaceMigrator templateMigrator = TemplateModelMigratorUtil.getTemplateModelWorkspaceMigrator();
        if (templateMigrator == null) {
            return;
        }
        boolean migrateTemplates = MessageDialog.openQuestion((Shell)shell, (String)Messages.TemplateModelEditorPart_TemplateMigrationTitle, (String)Messages.TemplateModelEditorPart_TemplateMigrationDescription);
        if (migrateTemplates) {
            final List<URI> templateModelsToMigrate = this.getTemplateModelWorkspaceURIsToMigrate();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        for (URI uri : templateModelsToMigrate) {
                            templateMigrator.performMigration(uri);
                        }
                    }
                    catch (TemplateModelMigrationException ex) {
                        throw new InvocationTargetException(ex);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(shell).run(true, false, runnable);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.TemplateModelEditorPart_TemplateMigrationErrorTitle, (String)Messages.TemplateModelEditorPart_TemplateMigrationErrorMessage);
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.view.template.tooling", Messages.TemplateModelEditorPart_TemplateMigrationErrorTitle, (Throwable)e));
            }
            catch (InterruptedException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.TemplateModelEditorPart_TemplateMigrationErrorTitle, (String)Messages.TemplateModelEditorPart_TemplateMigrationErrorMessage);
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.view.template.tooling", Messages.TemplateModelEditorPart_TemplateMigrationErrorTitle, (Throwable)e));
            }
        }
    }

    private List<URI> getTemplateModelWorkspaceURIsToMigrate() {
        LinkedList<URI> uris = new LinkedList<URI>();
        TemplateModelWorkspaceMigrator workspaceMigrator = TemplateModelMigratorUtil.getTemplateModelWorkspaceMigrator();
        if (workspaceMigrator == null) {
            return uris;
        }
        try {
            Object[] selectedURIs;
            Shell shell;
            ListSelectionDialog migrationDialog;
            List urIsToMigrate = workspaceMigrator.getURIsToMigrate();
            if (urIsToMigrate.size() > 0 && (migrationDialog = MigrationDialogHelper.getTemplateModelListMigrationDialog(shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), urIsToMigrate)).open() == 0 && (selectedURIs = migrationDialog.getResult()) != null) {
                Object[] objectArray = selectedURIs;
                int n = selectedURIs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selectedUri = objectArray[n2];
                    uris.add((URI)selectedUri);
                    ++n2;
                }
            }
        }
        catch (CoreException ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.view.template.tooling", ex.getMessage(), (Throwable)ex));
        }
        return uris;
    }

    protected boolean enableValidation() {
        return true;
    }
}

