/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.nebula.grid;

import java.util.LinkedHashSet;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.LocalizationAdapter;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.model.util.ViewModelPropertiesHelper;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.nebula.grid.GridControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.converter.EStructuralFeatureValueConverterService;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class GridControlDetailPanelRenderer
extends GridControlSWTRenderer {
    private ECPSWTView ecpView;
    private VView view;
    private Composite detailPanel;
    private Composite border;
    private ScrolledComposite scrolledComposite;

    @Inject
    public GridControlDetailPanelRenderer(VTableControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabindingEMF emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, ImageRegistryService imageRegistryService, EMFFormsEditSupport emfFormsEditSupport, EStructuralFeatureValueConverterService converterService, EMFFormsLocalizationService localizationService) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, imageRegistryService, emfFormsEditSupport, converterService, localizationService);
    }

    protected Composite createControlComposite(Composite composite) {
        this.border = new Composite(composite, 2048);
        GridLayout gridLayout = GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).create();
        this.border.setLayout((Layout)gridLayout);
        int totalHeight = this.getTableHeightHint() + this.getDetailPanelHeightHint() + gridLayout.verticalSpacing;
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(1, totalHeight).applyTo((Control)this.border);
        Composite tableComposite = new Composite(this.border, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).hint(1, this.getTableHeightHint()).applyTo((Control)tableComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.border);
        this.scrolledComposite = new ScrolledComposite(this.border, 512);
        this.scrolledComposite.setBackground(composite.getBackground());
        this.scrolledComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.scrolledComposite);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        this.detailPanel = this.createDetailPanel(this.scrolledComposite);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.detailPanel);
        this.scrolledComposite.setContent((Control)this.detailPanel);
        this.detailPanel.layout();
        Point point = this.detailPanel.computeSize(-1, -1);
        this.scrolledComposite.setMinHeight(point.y);
        return tableComposite;
    }

    protected int getDetailPanelHeightHint() {
        return 400;
    }

    protected Composite createDetailPanel(ScrolledComposite composite) {
        Composite detail = new Composite((Composite)this.scrolledComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo(detail);
        return detail;
    }

    protected VView getView(EObject selectedEObject) {
        if (this.view == null) {
            VView detailView = ((VTableControl)this.getVElement()).getDetailView();
            if (detailView == null) {
                VElement viewModel = this.getViewModelContext().getViewModel();
                VViewModelProperties properties = ViewModelPropertiesHelper.getInhertitedPropertiesOrEmpty((VElement)viewModel);
                detailView = ViewProviderHelper.getView((EObject)selectedEObject, (VViewModelProperties)properties);
            }
            this.view = detailView;
        }
        VView copy = (VView)EcoreUtil.copy((EObject)this.view);
        for (final Adapter adapter : this.view.eAdapters()) {
            if (!LocalizationAdapter.class.isInstance(adapter)) continue;
            copy.eAdapters().add((Object)new LocalizationAdapter(){

                public String localize(String key) {
                    return ((LocalizationAdapter)LocalizationAdapter.class.cast(adapter)).localize(key);
                }
            });
            break;
        }
        return copy;
    }

    protected void viewerSelectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            this.handleEmptySelection();
        } else if (((IStructuredSelection)IStructuredSelection.class.cast(event.getSelection())).size() != 1) {
            this.handleMultiSelection((IStructuredSelection)event.getSelection());
        } else {
            this.handleSingleSelection((IStructuredSelection)event.getSelection());
        }
        super.viewerSelectionChanged(event);
    }

    protected void handleSingleSelection(IStructuredSelection selection) {
        this.disposeDetail();
        Composite compositeToRenderOn = new Composite(this.detailPanel, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo(compositeToRenderOn);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)compositeToRenderOn);
        EObject object = (EObject)selection.getFirstElement();
        this.renderSelectedObject(compositeToRenderOn, object);
        this.border.layout(true, true);
        Point point = this.detailPanel.computeSize(-1, -1);
        this.scrolledComposite.setMinHeight(point.y);
    }

    protected void renderSelectedObject(Composite composite, EObject eObject) {
        VView detailView = this.getView(eObject);
        if (detailView == null) {
            Label label = new Label(composite, 0);
            label.setBackground(composite.getDisplay().getSystemColor(3));
            label.setText("No Detail View found.");
        } else {
            ViewModelContext childContext = this.getViewModelContext().getChildContext(eObject, this.getVElement(), detailView, new ViewModelService[0]);
            try {
                this.ecpView = ECPSWTViewRenderer.INSTANCE.render(composite, childContext);
            }
            catch (ECPRendererException ex) {
                this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            }
        }
    }

    protected void handleMultiSelection(IStructuredSelection selection) {
        this.disposeDetail();
    }

    protected void handleEmptySelection() {
        this.disposeDetail();
    }

    private void disposeDetail() {
        if (this.ecpView != null) {
            this.ecpView.getSWTControl().dispose();
            this.ecpView = null;
        }
        Control[] controlArray = this.detailPanel.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    protected void deleteRows(List<EObject> deletionList, EObject eObject, EStructuralFeature structuralFeature) {
        super.deleteRows(deletionList, eObject, structuralFeature);
        LinkedHashSet toDelete = new LinkedHashSet();
        VDiagnostic diagnostic = ((VTableControl)this.getVElement()).getDiagnostic();
        if (diagnostic == null) {
            return;
        }
        for (EObject deleteObject : deletionList) {
            toDelete.addAll(diagnostic.getDiagnostics(deleteObject));
            TreeIterator eAllContents = deleteObject.eAllContents();
            while (eAllContents.hasNext()) {
                toDelete.addAll(diagnostic.getDiagnostics((EObject)eAllContents.next()));
            }
        }
        diagnostic.getDiagnostics().removeAll(toDelete);
    }
}

