/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.structuralchange;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.common.RankingHelper;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.structuralchange.EMFFormsStructuralChangeTester;
import org.eclipse.emfforms.spi.core.services.structuralchange.StructuralChangeTesterInternal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="EMFFormsStructuralChangeTesterImpl")
public class EMFFormsStructuralChangeTesterImpl
implements EMFFormsStructuralChangeTester {
    private ReportService reportService;
    private final Set<StructuralChangeTesterInternal> structuralChangeTesters = new LinkedHashSet<StructuralChangeTesterInternal>();
    private static final RankingHelper<StructuralChangeTesterInternal> RANKING_HELPER = new RankingHelper(StructuralChangeTesterInternal.class, Double.NEGATIVE_INFINITY, Double.valueOf(Double.NEGATIVE_INFINITY));

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addStructuralChangeTesterInternal(StructuralChangeTesterInternal structuralChangeTester) {
        this.structuralChangeTesters.add(structuralChangeTester);
    }

    protected void removeStructuralChangeTesterInternal(StructuralChangeTesterInternal structuralChangeTester) {
        this.structuralChangeTesters.remove(structuralChangeTester);
    }

    public boolean isStructureChanged(final VDomainModelReference reference, EObject domainRootObject, ModelChangeNotification notification) {
        StructuralChangeTesterInternal bestTester = (StructuralChangeTesterInternal)RANKING_HELPER.getHighestRankingElement(this.structuralChangeTesters, (RankingHelper.RankTester)new RankingHelper.RankTester<StructuralChangeTesterInternal>(){

            public double getRank(StructuralChangeTesterInternal tester) {
                return tester.isApplicable(reference);
            }
        });
        if (bestTester == null) {
            this.reportService.report(new AbstractReport("Warning: Structural changes of the DMR: " + reference + "could not be analyzed because no suitable StructuralChangeTesterInternal was available."));
            return false;
        }
        return bestTester.isStructureChanged(reference, domainRootObject, notification);
    }
}

