/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.rule;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.internal.rule.CompositeConditionService;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.rule.ConditionService;
import org.eclipse.emf.ecp.view.spi.rule.model.Condition;
import org.eclipse.emf.ecp.view.spi.rule.model.IsProxyCondition;
import org.eclipse.emf.ecp.view.spi.rule.model.RulePackage;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConditionService.class})
public class IsProxyConditionService
extends CompositeConditionService<IsProxyCondition> {
    private EMFFormsDatabindingEMF databindings;
    private ReportService reportService;

    @Override
    public EClass getConditionType() {
        return RulePackage.Literals.IS_PROXY_CONDITION;
    }

    @Reference
    void setDatabindings(EMFFormsDatabindingEMF databindings) {
        this.databindings = databindings;
    }

    @Reference
    void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Override
    protected Iterable<? extends Condition> components(IsProxyCondition condition) {
        return Collections.emptyList();
    }

    @Override
    protected List<? extends EObject> getTargets(IsProxyCondition condition, EObject domainModel) {
        VDomainModelReference dmr = condition.getDomainModelReference();
        if (dmr == null) {
            return Collections.emptyList();
        }
        try {
            return this.databindings.getObservableList(dmr, domainModel);
        }
        catch (DatabindingFailedException e) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)e));
            return Collections.emptyList();
        }
    }

    @Override
    public Set<VDomainModelReference> getDomainModelReferences(IsProxyCondition condition) {
        VDomainModelReference dmr = condition.getDomainModelReference();
        if (dmr == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(dmr);
    }

    @Override
    public Set<UniqueSetting> getConditionSettings(IsProxyCondition condition, EObject domainModel) {
        Set<Object> result;
        VDomainModelReference dmr = condition.getDomainModelReference();
        if (dmr == null) {
            result = super.getConditionSettings(condition, domainModel);
        } else {
            try {
                result = Collections.singleton(UniqueSetting.createSetting((EStructuralFeature.Setting)this.databindings.getSetting(dmr, domainModel)));
            }
            catch (DatabindingFailedException e) {
                result = Collections.emptySet();
                this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)e));
            }
        }
        return result;
    }
}

