/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.core.swt;

import java.text.MessageFormat;
import org.eclipse.emf.ecp.view.model.common.AbstractGridCell;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.swt.graphics.Point;

public final class SimpleControlSWTRendererUtil {
    private static final Point VALIDATION_PREFERRED_SIZE = new Point(16, 17);

    private SimpleControlSWTRendererUtil() {
    }

    public static boolean showLabel(VControl control, ReportService reportService, String rendererName) {
        switch (control.getLabelAlignment()) {
            case DEFAULT: 
            case LEFT: {
                return true;
            }
            case NONE: {
                return false;
            }
        }
        reportService.report(new AbstractReport(MessageFormat.format("Label alignment {0} is not supported by renderer {1}. Label alignment set to default.", control.getLabelAlignment().getLiteral(), rendererName), 1));
        control.setLabelAlignment(LabelAlignment.DEFAULT);
        return true;
    }

    public static SWTGridCell createLabelCell(int column, AbstractSWTRenderer<? extends VElement> renderer, Optional<Integer> labelWidth) {
        SWTGridCell labelCell = new SWTGridCell(0, column, renderer);
        labelCell.setHorizontalGrab(false);
        labelCell.setVerticalGrab(false);
        labelCell.setHorizontalFill(false);
        labelCell.setHorizontalAlignment(AbstractGridCell.Alignment.BEGINNING);
        labelCell.setVerticalFill(false);
        labelCell.setVerticalAlignment(AbstractGridCell.Alignment.CENTER);
        labelCell.setRenderer(renderer);
        if (labelWidth.isPresent()) {
            labelCell.setPreferredSize(((Integer)labelWidth.get()).intValue(), -1);
        }
        return labelCell;
    }

    public static SWTGridCell createValidationCell(int column, AbstractSWTRenderer<? extends VElement> renderer) {
        SWTGridCell validationCell = new SWTGridCell(0, column, renderer);
        validationCell.setHorizontalGrab(false);
        validationCell.setVerticalGrab(false);
        validationCell.setHorizontalFill(false);
        validationCell.setHorizontalAlignment(AbstractGridCell.Alignment.CENTER);
        validationCell.setVerticalFill(false);
        validationCell.setVerticalAlignment(AbstractGridCell.Alignment.CENTER);
        validationCell.setRenderer(renderer);
        validationCell.setPreferredSize(VALIDATION_PREFERRED_SIZE);
        return validationCell;
    }

    public static SWTGridCell createControlCell(int column, AbstractSWTRenderer<? extends VElement> renderer) {
        SWTGridCell controlCell = new SWTGridCell(0, column, renderer);
        controlCell.setHorizontalGrab(true);
        controlCell.setVerticalGrab(false);
        controlCell.setHorizontalFill(true);
        controlCell.setVerticalFill(true);
        controlCell.setVerticalAlignment(AbstractGridCell.Alignment.CENTER);
        controlCell.setRenderer(renderer);
        return controlCell;
    }
}

