/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.validation;

import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.emf.ecp.internal.ui.validation.Messages;
import org.eclipse.emf.ecp.internal.ui.validation.ValidationContentProvider;
import org.eclipse.emf.ecp.internal.ui.validation.ValidationLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

@Creatable
public final class ValidationTreeViewerFactory {
    private static final ValidationTreeViewerFactory BASIC = new ValidationTreeViewerFactory();
    @Inject
    private Provider<ValidationContentProvider> contentProviderProvider;
    @Inject
    private Provider<ValidationLabelProvider> labelProviderProvider;

    static {
        ValidationTreeViewerFactory.BASIC.contentProviderProvider = ValidationContentProvider::new;
        ValidationTreeViewerFactory.BASIC.labelProviderProvider = ValidationLabelProvider::new;
    }

    public TreeViewer create(Composite parent) {
        Tree validationTree = new Tree(parent, 2816);
        validationTree.setHeaderVisible(true);
        validationTree.setLinesVisible(true);
        TreeViewer treeViewer = new TreeViewer(validationTree);
        TreeColumn messageColumn = new TreeColumn(validationTree, 16384);
        messageColumn.setAlignment(16384);
        messageColumn.setText(Messages.ValidationTreeViewerFactory_Description);
        messageColumn.setWidth(600);
        TreeColumn objectColumn = new TreeColumn(validationTree, 16384);
        objectColumn.setAlignment(16384);
        objectColumn.setText(Messages.ValidationTreeViewerFactory_Object);
        objectColumn.setWidth(200);
        TreeColumn featureColumn = new TreeColumn(validationTree, 16384);
        featureColumn.setAlignment(16384);
        featureColumn.setText(Messages.ValidationTreeViewerFactory_Feature);
        featureColumn.setWidth(200);
        treeViewer.setContentProvider((IContentProvider)this.contentProviderProvider.get());
        treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProviderProvider.get());
        ValidationTreeViewerFactory.addDoubleClickListener(treeViewer);
        return treeViewer;
    }

    public static TreeViewer createValidationViewer(Composite parent) {
        return BASIC.create(parent);
    }

    private static void addDoubleClickListener(TreeViewer treeViewer) {
        IConfigurationElement[] doubleClickListener;
        IConfigurationElement[] iConfigurationElementArray = doubleClickListener = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecp.ui.validation.doubleClickListener");
        int n = doubleClickListener.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            doubleClickListener = null;
            try {
                IDoubleClickListener dcl = (IDoubleClickListener)element.createExecutableExtension("class");
                treeViewer.addDoubleClickListener(dcl);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
    }
}

