/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.migrator;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.spi.view.migrator.string.StringViewModelMigrator;
import org.eclipse.emf.ecp.view.migrator.ViewModelMigrator;
import org.eclipse.emf.ecp.view.migrator.ViewModelWorkspaceMigrator;
import org.eclipse.emfforms.common.ServiceObjectTracker;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class ViewModelMigratorUtil {
    private static final String MIGRATOR_EXTENSION = "org.eclipse.emf.ecp.view.migrator.migrators";
    private static final String MIGRATOR_CLASS = "class";
    private static final String MIGRATOR_PRIORITY = "priority";
    private static ViewModelMigrator migrator;
    private static ServiceObjectTracker<ViewModelWorkspaceMigrator> viewModelWorkspaceMigratorObjectTracker;

    private ViewModelMigratorUtil() {
    }

    private static void readExtensionPoint() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(MIGRATOR_EXTENSION);
        int topPriority = 0;
        Class topClass = null;
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                try {
                    int priority = Integer.parseInt(configurationElement.getAttribute(MIGRATOR_PRIORITY));
                    if (priority > topPriority) {
                        Class migratorClass;
                        topClass = migratorClass = ViewModelMigratorUtil.loadClass(configurationElement.getContributor().getName(), configurationElement.getAttribute(MIGRATOR_CLASS));
                        topPriority = priority;
                    }
                }
                catch (ClassNotFoundException ex) {
                    ViewModelMigratorUtil.log(ex);
                }
                catch (InvalidRegistryObjectException ex) {
                    ViewModelMigratorUtil.log(ex);
                }
                ++n4;
            }
            ++n2;
        }
        if (topClass != null) {
            try {
                migrator = (ViewModelMigrator)topClass.newInstance();
            }
            catch (InstantiationException ex) {
                ViewModelMigratorUtil.log(ex);
            }
            catch (IllegalAccessException ex) {
                ViewModelMigratorUtil.log(ex);
            }
        }
    }

    public static ViewModelMigrator getViewModelMigrator() {
        if (migrator == null) {
            ViewModelMigratorUtil.readExtensionPoint();
        }
        return migrator;
    }

    public static StringViewModelMigrator getStringViewModelMigrator() {
        if (!StringViewModelMigrator.class.isInstance(ViewModelMigratorUtil.getViewModelMigrator())) {
            return null;
        }
        return (StringViewModelMigrator)StringViewModelMigrator.class.cast(ViewModelMigratorUtil.getViewModelMigrator());
    }

    public static ViewModelWorkspaceMigrator getViewModelWorkspaceMigrator() {
        if (viewModelWorkspaceMigratorObjectTracker == null) {
            Bundle bundle = FrameworkUtil.getBundle(ViewModelMigratorUtil.class);
            BundleContext bundleContext = bundle.getBundleContext();
            viewModelWorkspaceMigratorObjectTracker = new ServiceObjectTracker(bundleContext, ViewModelWorkspaceMigrator.class);
        }
        return (ViewModelWorkspaceMigrator)viewModelWorkspaceMigratorObjectTracker.getService();
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.valueOf(clazz) + bundleName);
        }
        return bundle.loadClass(clazz);
    }

    private static void log(Throwable throwable) {
        Bundle bundle = FrameworkUtil.getBundle(ViewModelMigratorUtil.class);
        BundleContext bundleContext = bundle.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(ReportService.class);
        if (serviceReference == null) {
            return;
        }
        ReportService reportService = (ReportService)bundleContext.getService(serviceReference);
        try {
            if (reportService == null) {
                return;
            }
            reportService.report(new AbstractReport(throwable));
        }
        finally {
            bundleContext.ungetService(serviceReference);
        }
    }
}

