/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.core.services.segments;

import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class RuntimeModeUtil {
    public static final String SEGMENT_GENERATION = "-enableSegmentGeneration";
    private static boolean segmentMode;

    private RuntimeModeUtil() {
    }

    public static boolean isSegmentMode() {
        String[] applicationArgs = Platform.getApplicationArgs();
        Arrays.stream(applicationArgs).filter(SEGMENT_GENERATION::equals).findFirst().ifPresent(s -> {
            boolean bl = segmentMode = true;
        });
        if (segmentMode) {
            RuntimeModeUtil.report(new AbstractReport("Segment Generation for legacy DMRs is enabled.", 1));
        }
        return segmentMode;
    }

    private static void report(AbstractReport report) {
        BundleContext bundleContext = FrameworkUtil.getBundle(RuntimeModeUtil.class).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(ReportService.class);
        ReportService reportService = (ReportService)bundleContext.getService(serviceReference);
        reportService.report(report);
        bundleContext.ungetService(serviceReference);
    }
}

