/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.spi.migration.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.edapt.internal.migration.impl.ModelValidator;
import org.eclipse.emf.edapt.internal.migration.impl.UpdatingList;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.AttributeSlot;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.MigrationFactory;
import org.eclipse.emf.edapt.spi.migration.MigrationPackage;
import org.eclipse.emf.edapt.spi.migration.Model;
import org.eclipse.emf.edapt.spi.migration.ModelResource;
import org.eclipse.emf.edapt.spi.migration.ReferenceSlot;
import org.eclipse.emf.edapt.spi.migration.Slot;
import org.eclipse.emf.edapt.spi.migration.Type;
import org.eclipse.emf.edapt.spi.migration.impl.ModelImpl;
import org.eclipse.emf.edapt.spi.migration.impl.SlotImpl;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.OCLHelper;

public class InstanceImpl
extends EObjectImpl
implements Instance {
    protected EList<Slot> slots;
    protected EList<ReferenceSlot> references;
    protected static final URI URI_EDEFAULT = null;
    protected URI uri = URI_EDEFAULT;
    protected static final String UUID_EDEFAULT = null;
    protected String uuid = UUID_EDEFAULT;

    protected InstanceImpl() {
    }

    protected EClass eStaticClass() {
        return MigrationPackage.Literals.INSTANCE;
    }

    @Override
    public EList<Slot> getSlots() {
        if (this.slots == null) {
            this.slots = new EObjectContainmentWithInverseEList(Slot.class, (InternalEObject)this, 0, 0);
        }
        return this.slots;
    }

    @Override
    public Type getType() {
        if (this.eContainerFeatureID() != 1) {
            return null;
        }
        return (Type)this.eContainer();
    }

    public NotificationChain basicSetType(Type newType, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newType, 1, msgs);
        return msgs;
    }

    @Override
    public void setType(Type newType) {
        if (newType != this.eInternalContainer() || this.eContainerFeatureID() != 1 && newType != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)((EObject)newType))) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newType != null) {
                msgs = ((InternalEObject)newType).eInverseAdd((InternalEObject)this, 1, Type.class, msgs);
            }
            if ((msgs = this.basicSetType(newType, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newType, (Object)newType));
        }
    }

    @Override
    public EList<ReferenceSlot> getReferences() {
        if (this.references == null) {
            this.references = new EObjectWithInverseResolvingEList.ManyInverse(ReferenceSlot.class, (InternalEObject)this, 2, 2);
        }
        return this.references;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void setUri(URI newUri) {
        URI oldUri = this.uri;
        this.uri = newUri;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldUri, (Object)this.uri));
        }
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public void setUuid(String newUuid) {
        String oldUuid = this.uuid;
        this.uuid = newUuid;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldUuid, (Object)this.uuid));
        }
    }

    @Override
    public <V> V get(EStructuralFeature feature) {
        if (feature instanceof EAttribute) {
            return this.getAttributeValue((EAttribute)feature);
        }
        if (feature instanceof EReference) {
            return this.getReferenceValue((EReference)feature);
        }
        return null;
    }

    private <V> V getAttributeValue(EAttribute attribute) {
        Slot slot = this.getSlot((EStructuralFeature)attribute);
        if (slot == null) {
            if (attribute.isMany()) {
                return (V)((Object)new UpdatingList(this, (EStructuralFeature)attribute));
            }
            if (attribute.getDefaultValue() != null) {
                return (V)attribute.getDefaultValue();
            }
            return null;
        }
        UpdatingList<Object> values = new UpdatingList<Object>(this, (EStructuralFeature)attribute, (Collection<Object>)((AttributeSlot)slot).getValues());
        if (attribute.isMany()) {
            return (V)((Object)values);
        }
        if (!values.isEmpty()) {
            return (V)values.get(0);
        }
        return null;
    }

    <V> V getReferenceValue(EReference reference) {
        Slot slot = this.getSlot((EStructuralFeature)reference);
        if (slot == null) {
            if (reference.isMany()) {
                return (V)((Object)new UpdatingList(this, (EStructuralFeature)reference));
            }
            if (reference.getDefaultValue() != null) {
                return (V)reference.getDefaultValue();
            }
            return null;
        }
        UpdatingList<Instance> values = new UpdatingList<Instance>(this, (EStructuralFeature)reference, (Collection<Instance>)((ReferenceSlot)slot).getValues());
        if (reference.isMany()) {
            return (V)((Object)values);
        }
        if (!values.isEmpty()) {
            return (V)values.get(0);
        }
        return null;
    }

    @Override
    public void set(EStructuralFeature feature, Object newValue) {
        if (feature.isMany()) {
            Collection oldValues = (Collection)this.get(feature);
            for (Object value : oldValues) {
                this.remove(feature, value);
            }
            Collection newValues = (Collection)newValue;
            for (Object value : newValues) {
                this.add(feature, value);
            }
        } else {
            if (newValue instanceof List) {
                throw new IllegalArgumentException("Single value expected, but list found");
            }
            Object oldValue = this.get(feature);
            if (oldValue != newValue || feature.isUnsettable()) {
                if (this.isSet(feature) && oldValue != null) {
                    this.remove(feature, oldValue);
                }
                if (newValue != null || feature.isUnsettable()) {
                    this.add(feature, newValue);
                }
            }
        }
    }

    @Override
    public Slot getSlot(EStructuralFeature feature) {
        for (Slot slot : this.getSlots()) {
            if (feature != slot.getEFeature()) continue;
            return slot;
        }
        return null;
    }

    @Override
    public <V> V evaluate(String expression) throws MigrationException {
        OCLExpression query;
        Model model = this.getType().getModel();
        this.enableReflection();
        OCL ocl = OCL.newInstance((EnvironmentFactory)EcoreEnvironmentFactory.INSTANCE);
        OCLHelper helper = ocl.createOCLHelper();
        helper.setContext((Object)this.eClass());
        try {
            query = helper.createQuery(expression);
        }
        catch (ParserException e) {
            throw new MigrationException("OCL expression '" + expression + "' could not be parsed", (Throwable)e);
        }
        ocl.setExtentMap(model.createExtentMap());
        Query queryEval = ocl.createQuery(query);
        Object result = queryEval.evaluate((Object)this);
        this.disableReflection();
        return (V)result;
    }

    @Override
    public EReference getContainerReference() {
        for (ReferenceSlot slot : this.getReferences()) {
            if (!slot.getEReference().isContainment()) continue;
            return slot.getEReference();
        }
        return null;
    }

    @Override
    public ModelResource getResource() {
        Model model = this.getType().getModel();
        Instance instance = this;
        while (instance.getContainer() != null) {
            for (ModelResource resource : model.getResources()) {
                if (!resource.getRootInstances().contains((Object)instance)) continue;
                return resource;
            }
            instance = instance.getContainer();
        }
        for (ModelResource resource : model.getResources()) {
            if (!resource.getRootInstances().contains((Object)instance)) continue;
            return resource;
        }
        return null;
    }

    @Override
    public boolean isProxy() {
        return this.getUri() != null;
    }

    @Override
    public void migrate(String className) {
        EClass eClass = this.checkAndGetClass(className);
        this.migrate(eClass);
    }

    private EClass checkAndGetClass(String className) {
        Metamodel metamodel = this.getType().getModel().getMetamodel();
        EClass eClass = metamodel.getEClass(className);
        if (eClass == null) {
            throw new IllegalArgumentException("Class " + className + " not found.");
        }
        return eClass;
    }

    @Override
    public EList<Instance> getInverse(String referenceName) {
        EReference reference = this.checkAndGetReference(referenceName);
        return this.getInverse(reference);
    }

    private EReference checkAndGetReference(String referenceName) {
        EReference reference = this.getType().getModel().getMetamodel().getEReference(referenceName);
        if (reference == null) {
            throw new IllegalArgumentException("Reference " + referenceName + " not found.");
        }
        return reference;
    }

    @Override
    public Instance getLink(String referenceName) {
        return (Instance)this.get(referenceName);
    }

    @Override
    public EList<Instance> getLinks(String referenceName) {
        return (EList)this.get(referenceName);
    }

    @Override
    public boolean instanceOf(String className) {
        EClass eClass = this.checkAndGetClass(className);
        return this.instanceOf(eClass);
    }

    @Override
    public void add(String featureName, Object value) {
        EStructuralFeature feature = this.checkAndGetFeature(featureName);
        this.add(feature, value);
    }

    @Override
    public void remove(String featureName, Object value) {
        EStructuralFeature feature = this.checkAndGetFeature(featureName);
        this.remove(feature, value);
    }

    @Override
    public void add(String featureName, int index, Object value) {
        EStructuralFeature feature = this.checkAndGetFeature(featureName);
        this.add(feature, index, value);
    }

    @Override
    public Instance getLink(EReference reference) {
        return (Instance)this.get((EStructuralFeature)reference);
    }

    @Override
    public EList<Instance> getLinks(EReference reference) {
        return (EList)this.get((EStructuralFeature)reference);
    }

    @Override
    public Instance copy() {
        HashMap<Instance, Instance> map = new HashMap<Instance, Instance>();
        Instance copy = this.copyTree(this, map);
        this.copyReferences(this, map);
        return copy;
    }

    private Instance copyTree(Instance original, Map<Instance, Instance> map) {
        EClass eClass = original.getEClass();
        Instance copi = this.getType().getModel().newInstance(eClass);
        for (EReference reference : eClass.getEAllReferences()) {
            Instance child2;
            if (!reference.isContainment()) continue;
            if (reference.isMany()) {
                for (Instance child2 : original.getLinks(reference)) {
                    copi.add((EStructuralFeature)reference, (Object)this.copyTree(child2, map));
                }
                continue;
            }
            child2 = (Instance)original.get((EStructuralFeature)reference);
            if (child2 == null) continue;
            copi.set((EStructuralFeature)reference, (Object)this.copyTree(child2, map));
        }
        for (EAttribute attribute : eClass.getEAllAttributes()) {
            copi.set((EStructuralFeature)attribute, original.get((EStructuralFeature)attribute));
        }
        map.put(original, copi);
        return copi;
    }

    private void copyReferences(Instance original, Map<Instance, Instance> map) {
        EClass eClass = original.getEClass();
        Instance copi = map.get(original);
        for (EReference reference : eClass.getEAllReferences()) {
            Instance ref2;
            if (reference.isContainment()) continue;
            if (reference.isMany()) {
                if (reference.getEOpposite() != null && !reference.getEOpposite().isMany()) continue;
                for (Instance ref2 : original.getLinks(reference)) {
                    if (map.get(ref2) != null) {
                        ref2 = map.get(ref2);
                    }
                    copi.add((EStructuralFeature)reference, (Object)ref2);
                }
                continue;
            }
            if (reference.getEOpposite() != null && reference.getEOpposite().isContainment() || (ref2 = (Instance)original.get((EStructuralFeature)reference)) == null) continue;
            if (map.get(ref2) != null) {
                ref2 = map.get(ref2);
            }
            copi.set((EStructuralFeature)reference, (Object)ref2);
        }
    }

    @Override
    public EList<Instance> getInverse(EReference reference) {
        EList<ReferenceSlot> slots = this.getReferences();
        BasicEList instances = new BasicEList();
        for (ReferenceSlot slot : slots) {
            if (reference != slot.getEReference()) continue;
            instances.add((Object)slot.getInstance());
        }
        return instances;
    }

    @Override
    public void migrate(EClass eClass) {
        Type oldType = this.getType();
        if (eClass != oldType.getEClass()) {
            ModelImpl model = (ModelImpl)oldType.getModel();
            model.removeDeleteType(oldType, this);
            Type type = model.getCreateType(eClass);
            type.getInstances().add((Object)this);
        }
    }

    @Override
    public <V> V unset(EStructuralFeature feature) {
        V value = this.get(feature);
        if (this.isSet(feature)) {
            if (feature.isMany()) {
                this.set(feature, (Object)Collections.EMPTY_LIST);
            } else {
                this.set(feature, null);
            }
        }
        return value;
    }

    @Override
    public void add(EStructuralFeature feature, int index, Object value) {
        if (feature instanceof EAttribute) {
            EAttribute attribute = (EAttribute)feature;
            AttributeSlot attributeSlot = this.getCreateAttributeSlot(attribute);
            if (!attribute.isUnique() || !attributeSlot.getValues().contains(value)) {
                attributeSlot.getValues().add(index, value);
            }
        } else {
            EReference reference = (EReference)feature;
            Instance target = (Instance)value;
            if (reference.isUnique() && this.contains(reference, target)) {
                return;
            }
            EReference opposite = reference.getEOpposite();
            if (opposite != null && reference.eContainer() != null) {
                if (!opposite.isMany()) {
                    target.unset((EStructuralFeature)opposite);
                }
                ReferenceSlot oppositeSlot = ((InstanceImpl)target).getCreateReferenceSlot(opposite);
                oppositeSlot.getValues().add((Object)this);
            }
            ReferenceSlot referenceSlot = this.getCreateReferenceSlot(reference);
            referenceSlot.getValues().add(index, (Object)target);
        }
    }

    private AttributeSlot getCreateAttributeSlot(EAttribute attribute) {
        AttributeSlot attributeSlot = (AttributeSlot)this.getSlot((EStructuralFeature)attribute);
        if (attributeSlot == null) {
            attributeSlot = MigrationFactory.eINSTANCE.createAttributeSlot();
            attributeSlot.setEAttribute(attribute);
            this.getSlots().add((Object)attributeSlot);
        }
        return attributeSlot;
    }

    ReferenceSlot getCreateReferenceSlot(EReference reference) {
        ReferenceSlot referenceSlot = (ReferenceSlot)this.getSlot((EStructuralFeature)reference);
        if (referenceSlot == null) {
            referenceSlot = MigrationFactory.eINSTANCE.createReferenceSlot();
            referenceSlot.setEReference(reference);
            this.getSlots().add((Object)referenceSlot);
        }
        return referenceSlot;
    }

    private boolean contains(EReference reference, Instance value) {
        ReferenceSlot referenceSlot = (ReferenceSlot)this.getSlot((EStructuralFeature)reference);
        if (referenceSlot != null) {
            return referenceSlot.getValues().contains((Object)value);
        }
        return false;
    }

    @Override
    public void remove(EStructuralFeature feature, Object value) {
        int index;
        SlotImpl slot = (SlotImpl)this.getSlot(feature);
        int n = index = slot != null ? slot.getValues().indexOf(value) : 0;
        if (index >= 0) {
            this.remove(feature, index);
        }
    }

    @Override
    public EClass getEClass() {
        return this.getType().getEClass();
    }

    @Override
    public void validate() {
        BasicDiagnostic chain = new BasicDiagnostic();
        this.validate((DiagnosticChain)chain);
    }

    @Override
    public boolean validate(DiagnosticChain chain) {
        final ModelValidator validator = new ModelValidator(this.getType().getModel());
        Diagnostician diagnostician = new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                EClass eClass = eObject.eClass();
                StringBuffer result = new StringBuffer(eClass.getName());
                if (eClass.getInstanceClassName() == null) {
                    result.append('/');
                    result.append(eClass.getEPackage().getNsURI());
                    result.append('#');
                    result.append(eClass.getName());
                }
                result.append('@');
                result.append(Integer.toHexString(eObject.hashCode()));
                return result.toString();
            }

            public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                boolean result = validator.validate(eClass, eObject, diagnostics, context);
                if (result || diagnostics != null) {
                    result &= this.doValidateContents(eObject, diagnostics, context);
                }
                return result;
            }
        };
        this.enableReflection();
        boolean result = diagnostician.validate((EObject)this, chain);
        this.disableReflection();
        return result;
    }

    private void disableReflection() {
        this.getType().getModel().setReflection(false);
    }

    private void enableReflection() {
        this.getType().getModel().setReflection(true);
    }

    @Override
    public <V> V get(String featureName) {
        EStructuralFeature feature = this.checkAndGetFeature(featureName);
        return this.get(feature);
    }

    private EStructuralFeature checkAndGetFeature(String featureName) {
        EStructuralFeature feature = this.getEClass().getEStructuralFeature(featureName);
        if (feature == null) {
            throw new IllegalArgumentException("Feature " + featureName + " not found.");
        }
        return feature;
    }

    @Override
    public void set(String featureName, Object value) {
        EStructuralFeature feature = this.checkAndGetFeature(featureName);
        this.set(feature, value);
    }

    @Override
    public boolean isSet(EStructuralFeature feature) {
        return this.getSlot(feature) != null;
    }

    @Override
    public boolean instanceOf(EClass eClass) {
        return this.getEClass() == eClass || this.getEClass().getEAllSuperTypes().contains((Object)eClass);
    }

    @Override
    public Instance getContainer() {
        for (ReferenceSlot slot : this.getReferences()) {
            if (!slot.getEReference().isContainment()) continue;
            return slot.getInstance();
        }
        return null;
    }

    @Override
    public EList<Instance> getContents() {
        BasicEList contents = new BasicEList();
        for (Slot slot : this.getSlots()) {
            ReferenceSlot referenceSlot;
            if (!(slot instanceof ReferenceSlot) || !(referenceSlot = (ReferenceSlot)slot).getEReference().isContainment()) continue;
            contents.addAll(referenceSlot.getValues());
        }
        return contents;
    }

    @Override
    public void add(EStructuralFeature feature, Object value) {
        SlotImpl slot = (SlotImpl)this.getSlot(feature);
        int index = slot != null ? slot.getValues().size() : 0;
        this.add(feature, index, value);
    }

    @Override
    public void remove(EStructuralFeature feature, int index) {
        if (feature instanceof EAttribute) {
            EAttribute attribute = (EAttribute)feature;
            this.removeDeleteAttribute(attribute, index);
        } else {
            EReference reference = (EReference)feature;
            EReference opposite = reference.getEOpposite();
            if (opposite != null && reference.eContainer() != null) {
                ReferenceSlot referenceSlot = (ReferenceSlot)this.getSlot((EStructuralFeature)reference);
                Instance target = (Instance)referenceSlot.getValues().get(index);
                int oppositeIndex = ((ReferenceSlot)target.getSlot((EStructuralFeature)opposite)).getValues().indexOf((Object)this);
                ((InstanceImpl)target).removeDeleteReference(opposite, oppositeIndex);
            }
            this.removeDeleteReference(reference, index);
        }
    }

    private void removeDeleteAttribute(EAttribute attribute, int index) {
        AttributeSlot attributeSlot = (AttributeSlot)this.getSlot((EStructuralFeature)attribute);
        attributeSlot.getValues().remove(index);
        if (attributeSlot.getValues().isEmpty()) {
            this.getSlots().remove((Object)attributeSlot);
        }
    }

    void removeDeleteReference(EReference reference, int index) {
        ReferenceSlot referenceSlot = (ReferenceSlot)this.getSlot((EStructuralFeature)reference);
        referenceSlot.getValues().remove(index);
        if (referenceSlot.getValues().isEmpty()) {
            this.getSlots().remove((Object)referenceSlot);
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getSlots()).basicAdd((Object)otherEnd, msgs);
            }
            case 1: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetType((Type)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getReferences()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getSlots()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return this.basicSetType(null, msgs);
            }
            case 2: {
                return ((InternalEList)this.getReferences()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 1: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 1, Type.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getSlots();
            }
            case 1: {
                return this.getType();
            }
            case 2: {
                return this.getReferences();
            }
            case 3: {
                return this.getUri();
            }
            case 4: {
                return this.getUuid();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getSlots().clear();
                this.getSlots().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setType((Type)newValue);
                return;
            }
            case 2: {
                this.getReferences().clear();
                this.getReferences().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setUri((URI)newValue);
                return;
            }
            case 4: {
                this.setUuid((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getSlots().clear();
                return;
            }
            case 1: {
                this.setType(null);
                return;
            }
            case 2: {
                this.getReferences().clear();
                return;
            }
            case 3: {
                this.setUri(URI_EDEFAULT);
                return;
            }
            case 4: {
                this.setUuid(UUID_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.slots != null && !this.slots.isEmpty();
            }
            case 1: {
                return this.getType() != null;
            }
            case 2: {
                return this.references != null && !this.references.isEmpty();
            }
            case 3: {
                return URI_EDEFAULT == null ? this.uri != null : !URI_EDEFAULT.equals(this.uri);
            }
            case 4: {
                return UUID_EDEFAULT == null ? this.uuid != null : !UUID_EDEFAULT.equals(this.uuid);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer();
        result.append("Instance of ");
        result.append(this.getType().getEClass().getName());
        if (this.getUri() != null) {
            result.append(" (proxy: " + this.getUri() + ")");
        } else if (this.getUuid() != null) {
            result.append(" (uuid: " + this.getUuid() + ")");
        }
        return result.toString();
    }

    public EClass eClass() {
        if (this.getType().getModel().isReflection()) {
            return this.getEClass();
        }
        return super.eClass();
    }

    public Object eGet(EStructuralFeature feature, boolean resolve, boolean coreType) {
        if (this.getType().getModel().isReflection()) {
            return this.get(feature);
        }
        return super.eGet(feature, resolve, coreType);
    }

    public boolean eIsSet(EStructuralFeature feature) {
        if (this.getType().getModel().isReflection()) {
            return this.getSlot(feature) != null;
        }
        return super.eIsSet(feature);
    }

    public EList<EObject> eContents() {
        if (this.getType().getModel().isReflection()) {
            EStructuralFeature[] features = ((EClassImpl.FeatureSubsetSupplier)this.getEClass().getEAllStructuralFeatures()).containments();
            return new EContentsEList((EObject)this, features);
        }
        return super.eContents();
    }

    public EList<EObject> eCrossReferences() {
        if (this.getType().getModel().isReflection()) {
            EStructuralFeature[] features = ((EClassImpl.FeatureSubsetSupplier)this.getEClass().getEAllStructuralFeatures()).crossReferences();
            return new EContentsEList((EObject)this, features);
        }
        return super.eCrossReferences();
    }
}

