/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emf2web.exporter;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecp.emf2web.controller.xtend.GenerationInfo;
import org.eclipse.emf.ecp.emf2web.exporter.GenerationExporter;
import org.eclipse.emf.ecp.emf2web.exporter.UserInteraction;
import org.eclipse.emf.ecp.emf2web.internal.messages.Messages;

public class FileGenerationExporter
implements GenerationExporter {
    private UserInteraction userInteraction;
    private boolean doCancel;

    @Override
    public void export(Collection<? extends GenerationInfo> generationInfos, UserInteraction userInteraction) throws IOException {
        this.userInteraction = userInteraction;
        this.doCancel = false;
        for (GenerationInfo generationInfo : generationInfos) {
            if (this.doCancel) continue;
            this.export(generationInfo);
        }
    }

    protected void export(GenerationInfo generationInfo) throws IOException {
        String exportString = this.wrapGeneration(generationInfo);
        URI location = generationInfo.getLocation();
        this.export(exportString, location);
    }

    protected String wrapGeneration(GenerationInfo generationInfo) {
        if (generationInfo.getWrapper() == null || !generationInfo.isWrap()) {
            return generationInfo.getGeneratedString();
        }
        return generationInfo.getWrapper().wrap(generationInfo.getGeneratedString(), generationInfo.getType());
    }

    protected void export(String exportString, URI location) throws IOException {
        if (location.isPlatform()) {
            try {
                this.handlePlatform(exportString, location);
            }
            catch (CoreException ex) {
                throw new IOException(ex);
            }
        } else if (location.isFile()) {
            this.handleFileSystem(exportString, location);
        } else {
            throw new IOException(MessageFormat.format(Messages.FileGenerationExporter_URI_Error, location.toString()));
        }
    }

    private void handlePlatform(String exportString, URI location) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFile((IPath)new Path(location.toPlatformString(true)));
        if (file.exists() && !this.askOverwriteAllowed(file.getLocationURI().toString())) {
            return;
        }
        if (file.exists()) {
            file.setContents((InputStream)new ByteArrayInputStream(exportString.getBytes()), 2, null);
        } else {
            this.prepareStructure(file.getParent());
            file.create((InputStream)new ByteArrayInputStream(exportString.getBytes()), 0, null);
        }
    }

    private void prepareStructure(IContainer container) throws CoreException {
        IContainer parent = container.getParent();
        if (parent instanceof IFolder) {
            this.prepareStructure(parent);
        }
        if (IFolder.class.isInstance(container) && !container.exists()) {
            IFolder folder = (IFolder)IFolder.class.cast(container);
            folder.create(false, true, null);
        }
    }

    private void handleFileSystem(String exportString, URI location) throws IOException {
        File file = new File(location.toFileString());
        if (file.exists() && !this.askOverwriteAllowed(file.getAbsolutePath())) {
            return;
        }
        this.writeToFileSystemFile(exportString, file);
    }

    private void writeToFileSystemFile(String exportString, File file) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));){
            writer.write(exportString);
        }
    }

    protected boolean askOverwriteAllowed(String fileName) {
        String toggleQuestion;
        String title = Messages.FileGenerationExporter_OverwriteWarning;
        String question = MessageFormat.format(Messages.FileGenerationExporter_OverwriteWarningMessage, fileName);
        int result = this.userInteraction.askQuestion(title, question, toggleQuestion = Messages.FileGenerationExporter_OverwriteWarningToggle);
        if (result == 2) {
            this.doCancel = true;
            return false;
        }
        if (result == 1) {
            return false;
        }
        return result == 0;
    }
}

