/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.diagnostician;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecp.diagnostician.ECPValidator;

public class PackageValidatorWrapper
implements EValidator {
    private final Map<EClassifier, ECPValidator> classifierToValidatorMap;

    public PackageValidatorWrapper(Map<EClassifier, ECPValidator> classifierToValidatorMap) {
        this.classifierToValidatorMap = classifierToValidatorMap;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ECPValidator ecpValidator = this.classifierToValidatorMap.get(eObject.eClass());
        if (ecpValidator == null) {
            return true;
        }
        return ecpValidator.validate(eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ECPValidator ecpValidator = this.classifierToValidatorMap.get(eClass);
        if (ecpValidator == null) {
            return true;
        }
        return ecpValidator.validate(eClass, eObject, diagnostics, context);
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ECPValidator ecpValidator = this.classifierToValidatorMap.get(eDataType);
        if (ecpValidator == null) {
            return true;
        }
        return ecpValidator.validate(eDataType, value, diagnostics, context);
    }
}

