/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.reveal;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import org.eclipse.emfforms.internal.core.services.reveal.EMFFormsRevealServiceImpl;
import org.eclipse.emfforms.spi.core.services.reveal.EMFFormsRevealProvider;
import org.eclipse.emfforms.spi.core.services.reveal.EMFFormsRevealService;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewContext;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewServiceFactory;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewServicePolicy;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewServiceScope;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="EMFFormsRevealServiceFactory")
public class EMFFormsRevealServiceFactory
implements EMFFormsViewServiceFactory<EMFFormsRevealService> {
    private final Object sync = new Object();
    private final Collection<EMFFormsRevealProvider> providers = new HashSet<EMFFormsRevealProvider>();
    private final Map<EMFFormsViewContext, WeakReference<EMFFormsRevealService>> serviceInstances = new WeakHashMap<EMFFormsViewContext, WeakReference<EMFFormsRevealService>>();

    @Override
    public EMFFormsViewServiceScope getScope() {
        return EMFFormsViewServiceScope.GLOBAL;
    }

    @Override
    public EMFFormsViewServicePolicy getPolicy() {
        return EMFFormsViewServicePolicy.IMMEDIATE;
    }

    @Override
    public double getPriority() {
        return 0.0;
    }

    @Override
    public Class<EMFFormsRevealService> getType() {
        return EMFFormsRevealService.class;
    }

    @Override
    public EMFFormsRevealService createService(EMFFormsViewContext context) {
        EMFFormsRevealServiceImpl result = new EMFFormsRevealServiceImpl(context);
        this.init(result, context);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(EMFFormsRevealService service, EMFFormsViewContext context) {
        Object object = this.sync;
        synchronized (object) {
            this.providers.forEach(service::addRevealProvider);
            this.serviceInstances.put(context, new WeakReference<EMFFormsRevealService>(service));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServices(Consumer<? super EMFFormsRevealService> action) {
        Object object = this.sync;
        synchronized (object) {
            Iterator<WeakReference<EMFFormsRevealService>> iter = this.serviceInstances.values().iterator();
            while (iter.hasNext()) {
                WeakReference<EMFFormsRevealService> next = iter.next();
                EMFFormsRevealService service = (EMFFormsRevealService)next.get();
                if (service == null) {
                    iter.remove();
                    continue;
                }
                action.accept(service);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addRevealProvider(EMFFormsRevealProvider provider) {
        Object object = this.sync;
        synchronized (object) {
            this.providers.add(provider);
            this.updateServices(service -> service.addRevealProvider(provider));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRevealProvider(EMFFormsRevealProvider provider) {
        Object object = this.sync;
        synchronized (object) {
            this.updateServices(service -> service.removeRevealProvider(provider));
            this.providers.remove(provider);
        }
    }
}

