/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.controlgrid.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.emfforms.spi.view.controlgrid.model.VControlGrid;
import org.eclipse.emf.emfforms.spi.view.controlgrid.model.VControlGridCell;
import org.eclipse.emf.emfforms.spi.view.controlgrid.model.VControlGridRow;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ControlGridSWTRenderer
extends AbstractSWTRenderer<VControlGrid> {
    private static final int SPACING = 20;
    private final Map<Control, Integer> controlsToAlign = new LinkedHashMap<Control, Integer>();
    private SWTGridDescription rendererGridDescription;
    private final EMFFormsRendererFactory rendererFactory;
    private SWTGridDescription emptyGridDescription;

    @Inject
    public ControlGridSWTRenderer(VControlGrid vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsRendererFactory rendererFactory) {
        super((VElement)vElement, viewContext, reportService);
        this.rendererFactory = rendererFactory;
    }

    protected EMFFormsRendererFactory getRendererFactory() {
        return this.rendererFactory;
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
            ((SWTGridCell)this.rendererGridDescription.getGrid().get(0)).setVerticalGrab(false);
        }
        return this.rendererGridDescription;
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Map<VControlGridCell, AbstractSWTRenderer<VElement>> renderers = this.getChildRenderers();
        Map<AbstractSWTRenderer<VElement>, SWTGridDescription> gridDescriptions = this.getGridDescriptions(renderers.values());
        this.emptyGridDescription = this.createGridDescriptionForEmptyCells(gridDescriptions.values());
        Map<SWTGridDescription, Integer> gridDescriptionToRequiredRendererColumnsMap = this.getRequiredColumnSizesOfRenderers(gridDescriptions.values());
        int actualSWTColumnCountAvailableForEachRenderer = this.getColumnsPerRenderer(gridDescriptionToRequiredRendererColumnsMap.values());
        Set<Integer> columnsAsPerControlGrid = this.getColumnCountsFromRows();
        int swtColumnsAsPerControlGrid = this.computeColumnCountSoThatAllRowsCanBeRendered(columnsAsPerControlGrid);
        int layoutColumns = this.computeColumnsForSWTLayout(actualSWTColumnCountAvailableForEachRenderer, swtColumnsAsPerControlGrid);
        Composite composite = this.createControlGridComposite(parent, layoutColumns);
        for (VControlGridRow row : ((VControlGrid)this.getVElement()).getRows()) {
            if (row.getCells().size() == 0) {
                Label label = new Label(composite, 0);
                GridDataFactory.fillDefaults().span(layoutColumns, 1).grab(false, false).applyTo((Control)label);
                continue;
            }
            int swtColumnsAvailableForRowElement = layoutColumns / row.getCells().size() - 1;
            for (VControlGridCell vCell : row.getCells()) {
                AbstractSWTRenderer<VElement> renderer = renderers.get(vCell);
                SWTGridDescription swtGridDescription = renderer != null ? gridDescriptions.get(renderer) : this.emptyGridDescription;
                int cellsWithoutHorizontalGrab = 0;
                int cellsWithHorizontalGrab = 0;
                for (SWTGridCell swtGridCell : swtGridDescription.getGrid()) {
                    if (!swtGridCell.isHorizontalGrab()) {
                        ++cellsWithoutHorizontalGrab;
                        continue;
                    }
                    ++cellsWithHorizontalGrab;
                }
                int swtColumnsAvailableForGrabingCells = swtColumnsAvailableForRowElement - cellsWithoutHorizontalGrab;
                int spanForSpanningCells = 0;
                int spanForLastSpanningCell = 0;
                if (cellsWithHorizontalGrab > 0) {
                    spanForSpanningCells = swtColumnsAvailableForGrabingCells / cellsWithHorizontalGrab;
                    spanForLastSpanningCell = swtColumnsAvailableForGrabingCells - (cellsWithHorizontalGrab - 1) * spanForSpanningCells;
                }
                this.applyLayout(composite, swtColumnsAvailableForRowElement, swtGridDescription, cellsWithoutHorizontalGrab, cellsWithHorizontalGrab, spanForSpanningCells, spanForLastSpanningCell);
                Label spacing = new Label(composite, 0);
                int xHint = row.getCells().get(row.getCells().size() - 1) != vCell ? this.getHorizontalSpacing() : 1;
                GridDataFactory.fillDefaults().hint(xHint, -1).applyTo((Control)spacing);
            }
        }
        for (AbstractSWTRenderer<VElement> renderer : renderers.values()) {
            renderer.finalizeRendering(composite);
        }
        Optional<Integer> pixelGridSize = this.getPixelGridSize();
        if (pixelGridSize.isPresent() && !this.controlsToAlign.isEmpty()) {
            composite.addControlListener((ControlListener)new AlignNonGrabbingControlsListener(composite, (Integer)pixelGridSize.get()));
        }
        composite.layout(true, true);
        return composite;
    }

    protected Optional<Integer> getPixelGridSize() {
        return Optional.empty();
    }

    int computeColumnsForSWTLayout(int actualSWTColumnCountAvailableForEachRenderer, int swtColumnsAsPerControlGrid) {
        int layoutColumns = swtColumnsAsPerControlGrid * actualSWTColumnCountAvailableForEachRenderer;
        return layoutColumns;
    }

    Composite createControlGridComposite(Composite parent, int layoutColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(layoutColumns).equalWidth(false).applyTo(composite);
        return composite;
    }

    protected int getHorizontalSpacing() {
        return 20;
    }

    private void applyLayout(Composite composite, int swtColumnsAvailableForRowElement, SWTGridDescription swtGridDescription, int cellsWithoutHorizontalGrab, int cellsWithHorizontalGrab, int spanForSpanningCells, int spanForLastSpanningCell) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        int withHorizontalGrabLeft = cellsWithHorizontalGrab;
        int withoutHorizontalGrabLeft = cellsWithoutHorizontalGrab;
        for (SWTGridCell swtGridCell : swtGridDescription.getGrid()) {
            GridData gridData;
            Composite wrapperComposite = new Composite(composite, 0);
            GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).applyTo(wrapperComposite);
            Object control = swtGridCell.getRenderer() != null ? ((AbstractSWTRenderer)swtGridCell.getRenderer()).render(swtGridCell, wrapperComposite) : new Label(wrapperComposite, 0);
            boolean withHorizontalGrab = true;
            if (swtGridCell.isHorizontalGrab()) {
                int hSpan = withHorizontalGrabLeft == 1 ? spanForLastSpanningCell : spanForSpanningCells;
                --withHorizontalGrabLeft;
                gridData = this.createGridDataForControlWithHorizontalGrab(swtGridDescription, swtGridCell, (Control)control, hSpan);
            } else if (cellsWithHorizontalGrab == 0 && withoutHorizontalGrabLeft == 1) {
                --withoutHorizontalGrabLeft;
                int hSpan = swtColumnsAvailableForRowElement - cellsWithoutHorizontalGrab + 1;
                gridData = this.createGridDataForControlWithHorizontalGrab(swtGridDescription, swtGridCell, (Control)control, hSpan);
            } else {
                withHorizontalGrab = false;
                --withoutHorizontalGrabLeft;
                gridData = this.createGridDataForControlWithoutHorizontalGrab(swtGridDescription, swtGridCell, (Control)control);
            }
            GridData controlGriddata = GridDataFactory.createFrom((GridData)gridData).span(1, 1).create();
            if (!gridData.grabExcessHorizontalSpace && withHorizontalGrab) {
                gridData.grabExcessHorizontalSpace = true;
            }
            if (gridData.grabExcessHorizontalSpace) {
                gridData.widthHint = 1;
            }
            if (!swtGridCell.isHorizontalGrab() && controlGriddata.grabExcessHorizontalSpace) {
                controlGriddata.grabExcessHorizontalSpace = false;
            }
            if (gridData.grabExcessHorizontalSpace && !controlGriddata.grabExcessHorizontalSpace) {
                int widthHint = controlGriddata.widthHint == -1 ? control.computeSize((int)-1, (int)-1).x : controlGriddata.widthHint;
                this.controlsToAlign.put((Control)control, widthHint);
                Optional<Integer> pixelGridSize = this.getPixelGridSize();
                if (pixelGridSize.isPresent()) {
                    controlGriddata.widthHint = this.computePreferredWidthBasedOnPixelGridSize(widthHint, (Integer)pixelGridSize.get());
                }
            }
            wrapperComposite.setLayoutData((Object)gridData);
            control.setLayoutData((Object)controlGriddata);
        }
    }

    protected GridData createGridDataForControlWithoutHorizontalGrab(SWTGridDescription swtGridDescription, SWTGridCell swtGridCell, Control control) {
        GridDataFactory gridDataFactory = GridDataFactory.fillDefaults().span(1, 1).grab(false, false).align(4, 0x1000000);
        if (swtGridCell.getPreferredSize() != null) {
            gridDataFactory.hint(swtGridCell.getPreferredSize());
        }
        GridData gridData = gridDataFactory.create();
        return gridData;
    }

    protected GridData createGridDataForControlWithHorizontalGrab(SWTGridDescription swtGridDescription, SWTGridCell swtGridCell, Control control, int hSpan) {
        GridData gridData = GridDataFactory.fillDefaults().span(hSpan, 1).grab(true, false).align(4, 0x1000000).create();
        if (swtGridCell.getPreferredSize() != null) {
            gridData.widthHint = swtGridCell.getPreferredSize().x;
            gridData.heightHint = swtGridCell.getPreferredSize().y;
        }
        return gridData;
    }

    int computeColumnCountSoThatAllRowsCanBeRendered(Collection<Integer> columnsAsPerControlGrid) {
        int swtColumnsAsPerControlGrid = 1;
        for (Integer integer : columnsAsPerControlGrid) {
            if (integer == 0) continue;
            swtColumnsAsPerControlGrid = ControlGridSWTRenderer.lcm(swtColumnsAsPerControlGrid, integer);
        }
        return swtColumnsAsPerControlGrid;
    }

    Set<Integer> getColumnCountsFromRows() {
        LinkedHashSet<Integer> columnsAsPerControlGrid = new LinkedHashSet<Integer>();
        for (VControlGridRow row : ((VControlGrid)this.getVElement()).getRows()) {
            columnsAsPerControlGrid.add(row.getCells().size());
        }
        return columnsAsPerControlGrid;
    }

    int getColumnsPerRenderer(Collection<Integer> collection) {
        int columnsPerRenderer = 1;
        for (Integer integer : collection) {
            columnsPerRenderer = ControlGridSWTRenderer.lcm(columnsPerRenderer, integer);
        }
        return columnsPerRenderer;
    }

    Map<SWTGridDescription, Integer> getRequiredColumnSizesOfRenderers(Collection<SWTGridDescription> collection) {
        LinkedHashMap<SWTGridDescription, Integer> requiredColumnSizesOfRenderers = new LinkedHashMap<SWTGridDescription, Integer>();
        for (SWTGridDescription description : collection) {
            requiredColumnSizesOfRenderers.put(description, description.getColumns() + 1);
        }
        return requiredColumnSizesOfRenderers;
    }

    Map<VControlGridCell, AbstractSWTRenderer<VElement>> getChildRenderers() {
        LinkedHashMap<VControlGridCell, AbstractSWTRenderer<VElement>> renderers = new LinkedHashMap<VControlGridCell, AbstractSWTRenderer<VElement>>();
        for (VControlGridRow row : ((VControlGrid)this.getVElement()).getRows()) {
            for (VControlGridCell cell : row.getCells()) {
                VControl control = cell.getControl();
                if (control == null) continue;
                try {
                    AbstractSWTRenderer renderer = this.getRendererFactory().getRendererInstance((VElement)control, this.getViewModelContext());
                    renderers.put(cell, (AbstractSWTRenderer<VElement>)renderer);
                }
                catch (EMFFormsNoRendererException ex) {
                    this.getReportService().report(new AbstractReport((Throwable)ex));
                }
            }
        }
        return renderers;
    }

    Map<AbstractSWTRenderer<VElement>, SWTGridDescription> getGridDescriptions(Collection<AbstractSWTRenderer<VElement>> renderers) {
        LinkedHashMap<AbstractSWTRenderer<VElement>, SWTGridDescription> gridDescriptions = new LinkedHashMap<AbstractSWTRenderer<VElement>, SWTGridDescription>();
        for (AbstractSWTRenderer<VElement> renderer : renderers) {
            SWTGridDescription gridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
            gridDescriptions.put(renderer, gridDescription);
        }
        return gridDescriptions;
    }

    protected SWTGridDescription createGridDescriptionForEmptyCells(Collection<SWTGridDescription> values) {
        SWTGridCell swtGridCell;
        Iterator<SWTGridDescription> iterator = values.iterator();
        if (!iterator.hasNext()) {
            return ControlGridSWTRenderer.createEmptySingleCellGridDescription();
        }
        SWTGridDescription first = iterator.next();
        int rows = first.getRows();
        int columns = first.getColumns();
        ArrayList<Boolean> grabHorizontal = new ArrayList<Boolean>();
        ArrayList<Point> sizes = new ArrayList<Point>();
        for (SWTGridCell swtGridCell2 : first.getGrid()) {
            grabHorizontal.add(swtGridCell2.isHorizontalGrab());
            Point size = swtGridCell2.getPreferredSize();
            if (size == null) {
                sizes.add(new Point(-1, -1));
                continue;
            }
            sizes.add(new Point(size.x, size.y));
        }
        while (iterator.hasNext()) {
            SWTGridDescription next = iterator.next();
            if (rows != next.getRows()) {
                return ControlGridSWTRenderer.createEmptySingleCellGridDescription();
            }
            if (columns != next.getColumns()) {
                return ControlGridSWTRenderer.createEmptySingleCellGridDescription();
            }
            int i = 0;
            while (i < next.getGrid().size()) {
                Point sizeToCheck;
                swtGridCell = (SWTGridCell)next.getGrid().get(i);
                if (!swtGridCell.isHorizontalGrab()) {
                    grabHorizontal.set(i, false);
                }
                if ((sizeToCheck = swtGridCell.getPreferredSize()) != null) {
                    Point curSize = (Point)sizes.get(i);
                    sizes.set(i, new Point(sizeToCheck.x > curSize.x ? sizeToCheck.x : curSize.x, sizeToCheck.y > curSize.y ? sizeToCheck.y : curSize.y));
                }
                ++i;
            }
        }
        SWTGridDescription swtGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(rows, columns, null);
        int j = 0;
        while (j < swtGridDescription.getGrid().size()) {
            swtGridCell = (SWTGridCell)swtGridDescription.getGrid().get(j);
            swtGridCell.setHorizontalGrab(((Boolean)grabHorizontal.get(j)).booleanValue());
            swtGridCell.setHorizontalFill(((Boolean)grabHorizontal.get(j)).booleanValue());
            swtGridCell.setPreferredSize((Point)sizes.get(j));
            ++j;
        }
        return swtGridDescription;
    }

    private static SWTGridDescription createEmptySingleCellGridDescription() {
        SWTGridDescription swtGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, null);
        ((SWTGridCell)swtGridDescription.getGrid().get(0)).setHorizontalGrab(false);
        ((SWTGridCell)swtGridDescription.getGrid().get(0)).setHorizontalFill(false);
        return swtGridDescription;
    }

    int computePreferredWidthBasedOnPixelGridSize(double prefWidth, int pixelGridSize) {
        return ((Double)Double.class.cast(Math.ceil(prefWidth / (double)pixelGridSize))).intValue() * pixelGridSize;
    }

    private static int gcd(int a, int b) {
        if (b == 0) {
            return a;
        }
        return ControlGridSWTRenderer.gcd(b, a % b);
    }

    private static int lcm(int a, int b) {
        return Math.abs(a * b) / ControlGridSWTRenderer.gcd(a, b);
    }

    private final class AlignNonGrabbingControlsListener
    implements ControlListener {
        private final Composite composite;
        private final int pixelGridSize;

        private AlignNonGrabbingControlsListener(Composite composite, int pixelGridSize) {
            this.composite = composite;
            this.pixelGridSize = pixelGridSize;
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            for (Map.Entry entry : ControlGridSWTRenderer.this.controlsToAlign.entrySet()) {
                int availableWidth = ((Control)entry.getKey()).getParent().getSize().x;
                if (availableWidth == 0) continue;
                int prefWidth = (Integer)entry.getValue();
                int widthHint = ControlGridSWTRenderer.this.computePreferredWidthBasedOnPixelGridSize(prefWidth, this.pixelGridSize);
                if (widthHint > availableWidth) {
                    widthHint = prefWidth > availableWidth ? prefWidth : availableWidth;
                }
                ((GridData)GridData.class.cast((Object)((Control)entry.getKey()).getLayoutData())).widthHint = widthHint;
            }
            this.composite.layout(true, true);
        }
    }
}

